<?php

// Ensure the trait is loaded
require_once plugin_dir_path(__FILE__) . 'trait-logger.php';

/**
 * Class to handle media library hooks
 */
class Altomatic_Scripts {
	use AltomaticLoggerTrait;


    /**
     * Define a constant for enabling debug logging. Set to true to enable.
     */
    const DEBUG_LOGGING = true;

    public static $version;

    /**
     * Initialize the hooks.
     */
    public static function init($version) {
        self::$version = $version;
        self::log('Initializing Altomatic_Scripts');

        add_action('admin_enqueue_scripts', [self::class, 'enqueue_admin_scripts']);
        add_action('enqueue_block_editor_assets', [self::class, 'enqueue_editor_assets']);


    }


    /**
     * Enqueue admin scripts and styles
     */
    public static function enqueue_admin_scripts($hook) {
        // Only load on our settings page
        if ($hook !== 'settings_page_altomatic') {
            return;
        }

        // Enqueue thickbox
        wp_enqueue_script('thickbox');
        wp_enqueue_style('thickbox');

        // Ensure dashicons are loaded
        wp_enqueue_style('dashicons');

        wp_enqueue_script(
            'altomatic-admin',
            plugin_dir_url(dirname(__FILE__)) . 'admin/js/altomatic-admin.js',
            array('jquery', 'thickbox', 'wp-api-fetch'),
            self::$version,
            true
        );

        wp_enqueue_style(
            'altomatic-admin',
            plugin_dir_url(dirname(__FILE__)) . 'admin/css/altomatic-admin.css',
            array('thickbox', 'dashicons'),
            self::$version
        );

        // Add REST API settings
        wp_localize_script('altomatic-admin', 'altomaticSettings', array(
            'root' => esc_url_raw(rest_url()),
            'nonce' => wp_create_nonce('wp_rest')
        ));

        wp_localize_script('altomatic-admin', 'altomaticL10n', array(
            'regenerateAltText' => __('Regenerate Alt Text', 'altomatic'),
            'regenerating' => __('Regenerating...', 'altomatic'),
            'altTextUpdated' => __('Alt text updated successfully', 'altomatic'),
            'checkingApi' => __('Checking API connection...', 'altomatic'),
            'enterApiKey' => __('Please enter your API key', 'altomatic'),
            'apiValid' => __('API key is valid', 'altomatic'),
            'apiError' => __('Error checking API connection', 'altomatic')
        ));
    }

    /**
     * Enqueue block editor assets
     */
    public static function enqueue_editor_assets() {
        self::log("Enqueueing format selector script");

        // Register and enqueue the script
        wp_register_script(
            'altomatic-format-selector',
            plugin_dir_url(dirname(__FILE__)) . 'js/format-selector.js',
            array(
                'wp-blocks',
                'wp-element',
                'wp-editor',
                'wp-components',
                'wp-compose',
                'wp-hooks',
                'wp-data',
                'wp-block-editor',
                'wp-api-fetch'  // Add wp-api-fetch as a dependency
            ),
            self::$version,
            true
        );

        wp_enqueue_script('altomatic-format-selector');
        static::log("Format selector script enqueued");
    }
}
