<?php
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Fired during plugin deactivation.
 *
 * @package    Altomatic
 * @subpackage Altomatic/includes
 */
class Altomatic_Deactivator {

    /**
     * Clean up plugin data and scheduled tasks.
     *
     * @return void
     */
    public static function deactivate() {
        // Clear any scheduled hooks
        wp_clear_scheduled_hook('altomatic_cleanup_failed');
        wp_clear_scheduled_hook('altomatic_cron_optimization');
        wp_clear_scheduled_hook('altomatic_process_image_size');
        wp_clear_scheduled_hook('altomatic_generate_alt_text');
    }
}