<?php
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Fired during plugin activation.
 *
 * @package    Altomatic
 * @subpackage Altomatic/includes
 */
class Altomatic_Activator {

    /**
     * Initialize plugin settings.
     *
     * @return void
     */
    public static function activate(): void {
        // Default options
        $default_options = array(
            'api_key' => '',
            'auto_generate_alt' => true,
            'format_conversion' => array('jpeg', 'webp'),
            'image_sizes' => array('full', 'thumbnail', 'medium', 'medium_large', 'large', '1536x1536', '2048x2048')
        );

        // Add options if they don't exist
        foreach ($default_options as $option => $value) {
            if (false === get_option('altomatic_' . $option)) {
                add_option('altomatic_' . $option, $value);
            }
        }

        // Clear cache
        wp_cache_flush();
    }
}
