<?php
/**
 * Plugin Name: Altomatic
 * Plugin URI: https://altomatic.ai/wordpress
 * Description: Compress images to WebP/AVIF and auto-generate SEO alt text with AI. Boost Core Web Vitals and accessibility.
 * Version: 1.0.10
 * Author: Altomatic.ai
 * Author URI: https://altomatic.ai
 * License: GPL v2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain: altomatic
 *
 * @package Altomatic
 */

// If this file is called directly, abort.
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

// Define plugin constants
define('ALTOMATIC_VERSION', '1.0.10');
define('ALTOMATIC_PATH', plugin_dir_path(__FILE__));
define('ALTOMATIC_URL', plugin_dir_url(__FILE__));

// Load required files
require_once ALTOMATIC_PATH . 'includes/class-altomatic.php';
require_once ALTOMATIC_PATH . 'includes/class-altomatic-api.php';

/**
 * Add settings link to plugins page
 */
add_filter('plugin_action_links_' . plugin_basename(__FILE__), function($links) {
    $settings_link = '<a href="' . admin_url('options-general.php?page=altomatic') . '">' . __('Settings', 'altomatic') . '</a>';
    array_unshift($links, $settings_link);
    return $links;
});

/**
 * The code that runs during plugin activation.
 */
function altomatic_activate() {
    require_once plugin_dir_path(__FILE__) . 'includes/class-altomatic-activator.php';
    Altomatic_Activator::activate();
}

/**
 * The code that runs during plugin deactivation.
 */
function altomatic_deactivate() {
    require_once plugin_dir_path(__FILE__) . 'includes/class-altomatic-deactivator.php';
    Altomatic_Deactivator::deactivate();
}

register_activation_hook(__FILE__, 'altomatic_activate');
register_deactivation_hook(__FILE__, 'altomatic_deactivate');

/**
 * Begins execution of the plugin.
 */
function altomatic_run() {
    static $plugin = null;

    if ($plugin === null) {
        $plugin = new Altomatic();
    }
}

// Start the plugin
altomatic_run();
