<?php
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Template for displaying alternative format URL fields
 *
 * @link       https://altomatic.io
 * @since      1.0.0
 *
 * @package    Altomatic
 * @subpackage Altomatic/admin/partials
 */

// Expected variables: $post_id, $format (optimized, webp, or avif), $size_data

$url = '';
$attachment_metadata = wp_get_attachment_metadata($post_id);
if (empty($attachment_metadata)) {
    return;
}

$base_url = dirname(wp_get_attachment_url($post_id));

// Get the URL based on format
switch ($format) {
    case 'jpeg':
        if (!empty($size_data['jpeg']['full']['file']) && file_exists($size_data['jpeg']['full']['file'])) {
            $filename = pathinfo($attachment_metadata['file'], PATHINFO_FILENAME);
            $url = $base_url . '/' . $filename . '.jpeg';
        }
        break;

    case 'webp':
        if (!empty($size_data['webp']['full']['file']) && file_exists($size_data['webp']['full']['file'])) {
            $filename = pathinfo($attachment_metadata['file'], PATHINFO_FILENAME);
            $url = $base_url . '/' . $filename . '.webp';
        }
        break;

    case 'avif':
        // For AVIF, check both full and medium sizes
        if (!empty($size_data['avif']['full']['file']) && file_exists($size_data['avif']['full']['file'])) {
            $filename = pathinfo($attachment_metadata['file'], PATHINFO_FILENAME);
            $url = $base_url . '/' . $filename . '.avif';
        } else if (!empty($size_data['avif']['medium']['file']) && file_exists($size_data['avif']['medium']['file'])) {
            // Medium size AVIF
            if (!empty($attachment_metadata['sizes']['medium']['file'])) {
                $medium_filename = pathinfo($attachment_metadata['sizes']['medium']['file'], PATHINFO_FILENAME) . '.avif';
                $url = $base_url . '/' . $medium_filename;
            }
        }
        break;
}

// Only display if we have a valid URL
if (!empty($url)):
?>
<div class="altomatic-url-field">
    <input type="text" readonly value="<?php echo esc_url($url); ?>" class="code">
    <button type="button" class="copy-button" title="<?php esc_attr_e('Copy to clipboard', 'altomatic'); ?>">
        <span class="dashicons dashicons-clipboard"></span>
    </button>
</div>
<?php endif; ?>
