<?php
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Template for displaying optimization status in media library column
 *
 * @link       https://altomatic.io
 * @since      1.0.0
 *
 * @package    Altomatic
 * @subpackage Altomatic/admin/partials
 */


// Expected variables: $post_id

// Get optimization stats
$stats = $this->get_optimization_stats($post_id);
?>

<div class="optimization-status">
    <?php if ($stats['status'] === 'optimized'): ?>
        <span class="dashicons dashicons-yes-alt"></span>
        <span>
            <?php esc_html_e('Optimized', 'altomatic'); ?>
            <?php if (!empty($stats['formats_count'])): ?>
                <br>
                <small><?php printf(
                            /* translators: %d: Number of formats optimized */
                            esc_html(_n('%d format optimized', '%d formats optimized', $stats['formats_count'], 'altomatic')),
                            esc_html($stats['formats_count'])
                        ); ?>
                </small>
            <?php endif; ?>
        </span>
    <?php elseif ($stats['status'] === 'processing'): ?>
        <span class="dashicons dashicons-update"></span>
        <span><?php esc_html_e('Processing', 'altomatic'); ?></span>
    <?php elseif ($stats['status'] === 'error'): ?>
        <span class="dashicons dashicons-warning"></span>
        <span><?php esc_html_e('Error', 'altomatic'); ?></span>
    <?php elseif ($stats['status'] === 'credits_exceeded'): ?>
        <span class="dashicons dashicons-marker"></span>
        <span>
            <?php esc_html_e('Not optimized', 'altomatic'); ?>
            <br>
            <small class="error"><?php esc_html_e('Credits exceeded', 'altomatic'); ?></small>
        </span>
    <?php else: ?>
        <span class="dashicons dashicons-marker"></span>
        <span><?php esc_html_e('Not optimized', 'altomatic'); ?></span>
    <?php endif; ?>
</div>

<?php if ($stats['status'] === 'optimized' && $stats['bytes_saved'] > 0): ?>
    <div class="optimization-info">
        <?php
        echo sprintf(
            /* translators: 1: Formatted size saved 2: Percentage saved */
            esc_html__('Saved %1$s (%2$s%%)', 'altomatic'),
            esc_html(size_format($stats['bytes_saved'], 1)),
            esc_html(number_format($stats['percent_saved'], 1))
        );
        ?>
        <br>
        <a href="#TB_inline?width=600&height=550&inlineId=altomatic-modal-<?php echo esc_attr($post_id); ?>"
            class="thickbox"
            title="<?php esc_attr_e('Altomatic Compression Details', 'altomatic'); ?>">
            <?php esc_html_e('Details', 'altomatic'); ?>
        </a>
    </div>
<?php endif; ?>

<?php
// Add the hidden modal div with the details
if ($stats['status'] === 'optimized' && !empty($stats['size_data'])):
    // Set $attachment_id for the compression-details.php template
    $attachment_id = $post_id;
    include plugin_dir_path(dirname(dirname(__FILE__))) . 'admin/partials/compression-details.php';
endif;
?>