<?php
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

// Get current settings
$auto_generate_alt = get_option('altomatic_auto_generate_alt', true);
$format_conversion = get_option('altomatic_format_conversion', array('jpeg', 'webp', 'avif'));
$image_sizes = get_option('altomatic_image_sizes', array('full', 'thumbnail', 'medium', 'medium_large', 'large'));

// Format settings for display
$format_labels = array(
    'jpeg' => 'JPEG',
    'webp' => 'WebP',
    'avif' => 'AVIF'
);

$size_labels = array(
    'full' => __('Full Size', 'altomatic'),
    'thumbnail' => __('Thumbnail', 'altomatic'),
    'medium' => __('Medium', 'altomatic'),
    'medium_large' => __('Medium Large', 'altomatic'),
    'large' => __('Large', 'altomatic')
);


?>

<div class="wrap altomatic-bulk">
    <h1><?php esc_html_e('Altomatic Bulk Optimization', 'altomatic'); ?></h1>

    <div class="altomatic-bulk-container">
        <div class="altomatic-settings-summary">
            <h2><?php esc_html_e('Current Settings', 'altomatic'); ?></h2>
            <div class="altomatic-settings-grid">
                <div class="altomatic-setting">
                    <h3><?php esc_html_e('Altomatic AI Alt Text', 'altomatic'); ?></h3>
                    <p><?php echo $auto_generate_alt ? esc_html__('Enabled', 'altomatic') : esc_html__('Disabled', 'altomatic'); ?></p>
                </div>
                <div class="altomatic-setting">
                    <h3><?php esc_html_e('Image Formats', 'altomatic'); ?></h3>
                    <p><?php echo esc_html(implode(', ', array_map(function($format) use ($format_labels) {
                        return $format_labels[$format] ?? $format;
                    }, $format_conversion))); ?></p>
                </div>
                <div class="altomatic-setting">
                    <h3><?php esc_html_e('Image Sizes', 'altomatic'); ?></h3>
                    <p><?php echo esc_html(implode(', ', array_map(function($size) use ($size_labels) {
                        return $size_labels[$size] ?? $size;
                    }, $image_sizes))); ?></p>
                </div>
            </div>
            <div class="altomatic-settings-actions">
                <a href="<?php echo esc_url(admin_url('options-general.php?page=altomatic')); ?>" class="button altomatic-button">
                    <?php esc_html_e('Change Settings', 'altomatic'); ?>
                </a>
            </div>
        </div>

        <div class="altomatic-bulk-stats">
            <h2><?php esc_html_e('Images to Process', 'altomatic'); ?></h2>
            <div class="altomatic-stats-grid">
                <div class="altomatic-stat-box">
                    <h3><?php esc_html_e('Unoptimized Images', 'altomatic'); ?></h3>
                    <div class="altomatic-count-container">
                        <span class="altomatic-unoptimized-count">-</span>
                        <span class="altomatic-count-label"><?php esc_html_e('images', 'altomatic'); ?></span>
                    </div>
                </div>
                <div class="altomatic-stat-box">
                    <h3><?php esc_html_e('Missing AI Alt Text', 'altomatic'); ?></h3>
                    <div class="altomatic-count-container">
                        <span class="altomatic-missing-alt-count">-</span>
                        <span class="altomatic-count-label"><?php esc_html_e('images', 'altomatic'); ?></span>
                    </div>
                </div>
            </div>
        </div>

        <div class="altomatic-bulk-actions">
            <div id="altomatic-no-images" class="notice notice-success" style="display: none;">
                <p><?php esc_html_e('All images are optimized and up to date!', 'altomatic'); ?></p>
            </div>
            <button id="start-bulk-optimization" class="button button-primary altomatic-button" style="display: none;">
                <?php esc_html_e('Start Bulk Processing', 'altomatic'); ?>
            </button>
        </div>

        <div class="altomatic-progress-container" style="display: none;">
            <div class="altomatic-progress-bar">
                <div class="altomatic-progress" style="width: 0%"></div>
            </div>
            <div class="altomatic-progress-stats">
                <span class="altomatic-optimized-count">0</span> / <span class="altomatic-total-count">0</span>
                <span class="altomatic-percentage">0%</span>
            </div>
        </div>

        <div class="altomatic-status-messages"></div>
    </div>
</div>
