<?php
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
?>

<div class="wrap altomatic">
    <div class="altomatic-header">
        <h1><?php echo esc_html(get_admin_page_title()); ?></h1>
    </div>

    <?php settings_errors(); ?>

    <div class="altomatic-section">
        <form method="post" action="options.php">
            <?php
            settings_fields('altomatic_settings');
            do_settings_sections('altomatic_settings');
            ?>

            <div id="api-key-status"></div>

            <?php submit_button(); ?>
        </form>
    </div>

    <div class="altomatic-section">
        <h2><?php esc_html_e('Optimization Statistics', 'altomatic'); ?></h2>
        <div class="altomatic-stats">
            <div class="stat-box">
                <h3><?php esc_html_e('Total Images Optimized', 'altomatic'); ?></h3>
                <p class="stat-value"><?php echo esc_html(get_option('altomatic_total_optimized', 0)); ?></p>
            </div>
            <div class="stat-box">
                <h3><?php esc_html_e('Total Space Saved', 'altomatic'); ?></h3>
                <p class="stat-value"><?php
                    $bytes_saved = get_option('altomatic_total_bytes_saved', 0);
                    echo esc_html(size_format($bytes_saved));
                ?></p>
            </div>
            <div class="stat-box">
                <h3><?php esc_html_e('Average Reduction', 'altomatic'); ?></h3>
                <p class="stat-value"><?php
                    $avg_reduction = get_option('altomatic_average_reduction', 0);
                    echo esc_html(number_format($avg_reduction, 1) . '%');
                ?></p>
            </div>
        </div>
    </div>
</div>