/**
 * Altomatic Admin JavaScript
 */
jQuery(document).ready(function($) {
    let isOptimizing = false;
    const BATCH_SIZE = 1;

    // Function to check and update button visibility
    function updateButtonVisibility(unoptimizedCount, missingAltCount) {
        const totalCount = unoptimizedCount + missingAltCount;
        if (totalCount === 0) {
            $('#start-bulk-optimization').hide();
            $('#altomatic-no-images').show();
        } else {
            $('#start-bulk-optimization').show();
            $('#altomatic-no-images').hide();
        }
    }

    // Function to update both counts
    function updateCounts() {
        let unoptimizedCount = 0;
        let missingAltCount = 0;
        let countsFetched = 0;

        // Get unoptimized count
        $.ajax({
            url: altomaticAdmin.ajaxurl,
            type: 'GET',
            data: {
                action: 'altomatic_get_unoptimized_count',
                _ajax_nonce: altomaticAdmin.nonce
            },
            success: function(response) {
                if (response.success) {
                    unoptimizedCount = response.data.count;
                    $('.altomatic-unoptimized-count').text(unoptimizedCount);
                }
                countsFetched++;
                if (countsFetched === 2) {
                    updateButtonVisibility(unoptimizedCount, missingAltCount);
                }
            },
            error: function(xhr, status, error) {
                console.error('Error getting count:', error);
                addStatusMessage('Error getting unoptimized image count: ' + error, 'error');
            }
        });

        // Get missing alt text count
        $.ajax({
            url: altomaticAdmin.ajaxurl,
            type: 'GET',
            data: {
                action: 'altomatic_get_missing_alt_count',
                _ajax_nonce: altomaticAdmin.nonce
            },
            success: function(response) {
                if (response.success) {
                    missingAltCount = response.data.count;
                    $('.altomatic-missing-alt-count').text(missingAltCount);
                }
                countsFetched++;
                if (countsFetched === 2) {
                    updateButtonVisibility(unoptimizedCount, missingAltCount);
                }
            },
            error: function(xhr, status, error) {
                console.error('Error getting alt text count:', error);
                addStatusMessage('Error getting missing alt text count: ' + error, 'error');
            }
        });
    }

    // Initial counts update
    updateCounts();

    // Function to add status message
    function addStatusMessage(message, type = 'info') {
        const messageHtml = `<div class="altomatic-status-message altomatic-status-${type}">${message}</div>`;
        $('.altomatic-status-messages').prepend(messageHtml);
    }

    // Function to clear status messages
    function clearStatusMessages() {
        $('.altomatic-status-messages').empty();
    }

    // Function to update progress
    function updateProgress(processed, total) {
        const percentage = Math.round((processed / total) * 100);
        $('.altomatic-progress').css('width', percentage + '%');
        $('.altomatic-optimized-count').text(processed);
        $('.altomatic-total-count').text(total);
        $('.altomatic-percentage').text(percentage + '%');
    }

    // Function to process a batch of images
    async function processBatch(current_batch, total) {
        try {
            console.log('Processing batch...', current_batch, total);
            const response = await $.ajax({
                url: altomaticAdmin.ajaxurl,
                method: 'POST',
                data: {
                    action: 'altomatic_bulk_optimize',
                    batch_size: BATCH_SIZE,
                    _ajax_nonce: altomaticAdmin.nonce
                }
            });

            if (response.success) {
                // Update progress for the processed image
                const processed = (current_batch + 1) * BATCH_SIZE;
                updateProgress(processed, total);

                // Check if we have more images to process
                if (processed < total) {
                    // Continue with next image after a short delay
                    setTimeout(() => {
                        processBatch(current_batch + 1, total);
                    }, 100);
                } else {
                    // All images processed
                    isOptimizing = false;
                    clearStatusMessages();
                    addStatusMessage('Bulk processing completed successfully!', 'success');
                    $('#start-bulk-optimization').show();
                    // Update counts after completion
                    setTimeout(updateCounts, 500);
                }
            } else {
                // If there's an error give up
                addStatusMessage('Error processing images: ' + response.data || 'Unknown error', 'error');

            }
        } catch (error) {
            // If there's an error give up
            addStatusMessage('Error: ' + error.message, 'error');
        }
    }

    // Start bulk optimization
    $('#start-bulk-optimization').on('click', function() {
        if (isOptimizing) return;

        isOptimizing = true;
        clearStatusMessages();
        $('.altomatic-progress-container').show();
        $('#start-bulk-optimization').hide();

        // Get initial count and start processing
        $.ajax({
            url: altomaticAdmin.ajaxurl,
            type: 'GET',
            data: {
                action: 'altomatic_get_unoptimized_count',
                _ajax_nonce: altomaticAdmin.nonce
            },
            success: function(response) {
                if (response.success && response.data.count > 0) {
                    const total = response.data.count; // This is just unoptimized count
                    updateProgress(0, total);
                    processBatch(0, total);
                } else {
                    addStatusMessage('No images to process.', 'info');
                    isOptimizing = false;
                    $('.altomatic-progress-container').hide();
                    $('#start-bulk-optimization').show();
                    updateCounts();
                }
            },
            error: function(xhr, status, error) {
                addStatusMessage('Error getting unoptimized image count: ' + error, 'error');
                isOptimizing = false;
                $('.altomatic-progress-container').hide();
                $('#start-bulk-optimization').show();
            }
        });
    });
});
