# 🖼️ Altomatic - AI Image Optimization for WordPress

[![WordPress Plugin Version](https://img.shields.io/wordpress/plugin/v/altomatic.svg)](https://wordpress.org/plugins/altomatic/)
[![License](https://img.shields.io/badge/license-GPL--2.0%2B-blue.svg)](https://www.gnu.org/licenses/gpl-2.0.html)
[![PRs Welcome](https://img.shields.io/badge/PRs-welcome-brightgreen.svg)](http://makeapullrequest.com)

> Transform your WordPress site's performance and accessibility with AI-powered image optimization and alt text generation.

## ✨ Key Features

- 🤖 **AI-Powered Alt Text Generation**
  - Automatically generate accurate, descriptive alt text
  - Improve accessibility and SEO in one click
  - Support for multiple languages

- 🚀 **Intelligent Image Optimization**
  - Convert images to WebP and AVIF formats
  - Maintain original image quality
  - Optimize responsive image variants
  - Smart compression algorithms

- ⚡ **Performance First**
  - Automatic optimization of new uploads
  - Bulk optimization for existing media
  - Intelligent srcset optimization for responsive images
  - Modern format delivery (WebP/AVIF) with fallbacks

- ⚙️ **Easy Configuration**
  - Simple WordPress admin interface
  - Customizable image size selection
  - Format conversion options
  - Automatic processing settings

## 🚀 Getting Started

### Installation

**WordPress Plugin Directory (Recommended)**
1. Visit `Plugins > Add New` in your WordPress admin
2. Search for "Altomatic"
3. Click "Install Now" followed by "Activate"

**Manual Installation**
1. Download the latest release from our [website](https://altomatic.ai/download)
2. Upload the plugin through WordPress admin or extract to `/wp-content/plugins/`
3. Activate through the 'Plugins' menu

### Configuration

1. Sign up for an API key at [altomatic.ai](https://altomatic.ai)
2. Go to `Settings > Altomatic` in WordPress admin
3. Enter your API key
4. Configure your preferences:
   - Select image sizes to optimize
   - Choose output formats (Original/WebP/AVIF)
   - Enable automatic alt text generation
   - Configure srcset optimization

## 🎯 Usage

### Automatic Processing
- New image uploads are automatically optimized and tagged with AI-generated alt text
- Responsive image srcsets are automatically updated to use optimized versions

### Bulk Optimization
1. Navigate to `Media > Bulk Optimize`
2. Click "Start Optimization"

### Manual Processing
1. Go to Media Library
2. Click on any image
3. In the sidebar:
   - Click "Regenerate Alt Text" for new AI alt text
   - Click "Optimize Image" for image optimization

### Responsive Images
- Enable srcset optimization in settings
- WordPress automatically serves the best format (AVIF > WebP > Original)
- Maintains compatibility across all browsers

## 📊 Credits and Usage

- Monitor credit usage in WordPress admin
- View optimization statistics
- Manage account and credits at [altomatic.ai](https://altomatic.ai/profile)

## 📫 Support & Contact

- 📧 Email: [support@altomatic.ai](mailto:support@altomatic.ai)
- 🌐 Website: [altomatic.ai](https://altomatic.ai)
- 🐛 Issues: [GitHub Issues](https://github.com/altomatic/altomatic-wp/issues)

## 📜 License

This project is licensed under the GPL v2 or later - see the [LICENSE](LICENSE) file for details.

## 📝 Changelog

See [CHANGELOG.md](CHANGELOG.md) for release notes and version history.

---

<p align="center">
Made with ❤️ by <a href="https://altomatic.ai">Altomatic</a>
</p>
