<?php

namespace GoodWP\Altinator\Vendor\GoodWP\Common\Traits;

/**
 * A trait to make a class a singleton.
 */
trait Singleton {
    /**
     * Current instance
     *
     * @var static|null
     */
    protected static ?self $instance;

    /**
     * Get the current plugin main instance
     *
     * @param mixed ...$args Any arguments pass to the constructor.
     * @return static
     */
    public static function get_instance( ...$args ): static {
        if ( ! isset( static::$instance ) ) {
            // @phpstan-ignore new.static
            static::$instance = new static( ...$args );
        }
        return static::$instance;
    }
}
