<?php

namespace GoodWP\Altinator\Vendor\GoodWP\Common\Traits;

use GoodWP\Altinator\Vendor\GoodWP\Common\Exceptions\No_Instance_Exception;

/**
 * A trait to make a class a singleton.
 * This kind of singleton needs to be explicitly created before get_instance can be called.
 */
trait Forced_Singleton {

    /**
     * Current instance
     *
     * @var static|null
     */
    protected static ?self $instance;

    /**
     * Get the current instance.
     *
     * @return static
     * @throws No_Instance_Exception If no instance was created yet.
     */
    public static function get_instance(): static {
        if ( ! isset( static::$instance ) ) {
            throw new No_Instance_Exception( 'No instance initialized yet.' );
        }

        return static::$instance;
    }

    /**
     * Create an instance (only if there's not already an instance)
     *
     * @param mixed ...$args Any arguments pass to the constructor.
     * @return static
     */
    public static function create( ...$args ): static {
        if ( ! isset( static::$instance ) ) {
            // @phpstan-ignore new.static
            static::$instance = new static( ...$args );
        }
        return static::$instance;
    }
}
