<?php

namespace GoodWP\Altinator\Vendor\GoodWP\Common\Templates;

/**
 * A service to render templates which allows overwriting templates in themes and filtering of output.
 */
interface Template_Renderer_Contract {
	/**
	 * Renders a rendered template, provides hooks to filter args, template and output.
	 *
	 * @param string|array $template Template name(s) to be rendered (@see locateTemplate).
	 * @param array        $data Data passed to the template as $data variable.
	 * @return void
	 */
	public function render( $template, array $data ): void;

	/**
	 * Get a rendered template, provides hooks to filter args, template and output.
	 *
	 * @param string|array $template Template name(s) to be rendered (@see locateTemplate).
	 * @param array        $data Data passed to the template as $data variable.
	 * @return string
	 */
	public function get( $template, array $data ): string;
}
