<?php

namespace GoodWP\Altinator\Vendor\GoodWP\Common\Templates;

use Exception;

/**
 * Adds setter and (protected) getter for the setter-injection of a Template_Renderer.
 *
 * @see Template_Renderer_Contract
 */
trait Has_Templates {
	/**
	 * The injected template renderer instance to use
	 *
	 * @var Template_Renderer_Contract|null
	 */
	protected ?Template_Renderer_Contract $template_renderer = null;

	/**
	 * Gets the template renderer instance
	 *
	 * @return Template_Renderer_Contract
     * @throws Exception If no template renderer is set.
	 */
	protected function get_template_renderer(): Template_Renderer_Contract {
		if ( $this->template_renderer ) {
			return $this->template_renderer;
		}

		throw new Exception( 'No Template Renderer set.' );
	}

    /**
     * Sets the Template_Renderer_Contract instance to use.
     *
     * @param Template_Renderer_Contract|null $template_renderer The template renderer to use.
     * @return void
     */
	public function set_template_renderer( ?Template_Renderer_Contract $template_renderer ): void {
		$this->template_renderer = $template_renderer;
	}
}
