<?php

namespace GoodWP\Altinator\Vendor\GoodWP\Common\Plugin;

use GoodWP\Altinator\Vendor\GoodWP\Common\Contracts\Bootable;

/**
 * Service for loading i18n(internationalization)/l18n(localization) features.
 *
 * @package GoodWP\Common\Plugin
 */
class I18n implements Bootable {

	/**
	 * Creates a new I18n instance.
	 *
	 * @param string $plugin_dir Path of the plugin.
	 * @param string $text_domain The text domain to load.
	 */
	public function __construct( protected string $plugin_dir, protected string $text_domain ) {
	}

    /**
	 * {@inheritDoc}
     */
	public function boot(): void {
        add_action( 'init', [ $this, 'load_text_domain' ] );
	}

    /**
     * Load the plugin's text domain and language files.
     *
     * @return void
     */
	public function load_text_domain(): void {
		load_plugin_textdomain( $this->text_domain, false, basename( $this->plugin_dir ) . '/languages' );
	}
}
