<?php

namespace GoodWP\Altinator\Vendor\GoodWP\Common\Plugin;

use GoodWP\Altinator\Vendor\GoodWP\Common\Contracts\Bootable;
use GoodWP\Altinator\Vendor\GoodWP\Common\Contracts\Runnable;
use GoodWP\Altinator\Vendor\GoodWP\Common\Traits\Singleton;

/**
 * Service for handling plugin deactivation.
 */
abstract class Deactivation implements Bootable, Runnable {
    use Singleton;

    /**
     * Creates a new activation instance.
     *
     * @param string $plugin_file The main plugin file. Required for activation hook.
     */
    public function __construct( protected string $plugin_file ) {
    }

    /**
     * {@inheritDoc}
     *
     * Adds callback to register_deactivation_hook.
     * If boot method is only called on activation hook itself, it should be called earlier (e.g. 1).
     */
    public function boot(): void {
        register_deactivation_hook( $this->plugin_file, [ $this, 'run' ] );
    }
}
