<?php

namespace GoodWP\Altinator\Vendor\GoodWP\Common\Helper;

/**
 * String helpers.
 *
 * @package GoodWP\Common\Helper
 */
abstract class Str {
	/**
	 * The cache of snake-cased words.
	 *
	 * @var array
	 */
	protected static $snake_cache = [];

	/**
	 * The cache of camel-cased words.
	 *
	 * @var array
	 */
	protected static $camel_cache = [];

    /**
     * Convert a value to camel case.
     *
     * @param string $input The string to convert.
     * @param bool   $lower_first Whether to lowercase the first letter.
     * @param string $separator The seperator used in the original string.
     * @return string
     */
	public static function camel( string $input, bool $lower_first = true, string $separator = '_' ): string {
		if ( isset( static::$camel_cache[ $input ] ) ) {
			return static::$camel_cache[ $input ];
		}

		$value                         = str_replace( $separator, '', ucwords( $input, $separator ) );
        $value                         = $lower_first ? lcfirst( $value ) : ucfirst( $value );
        static::$camel_cache[ $input ] = $value;
		return $value;
	}

    /**
     * Convert a string to snake case.
     *
     * @param  string $input The string to convert.
     * @param  string $separator The separator to use.
     * @return string
     */
	public static function snake( string $input, string $separator = '_' ): string {
		$key = $input;

		if ( isset( static::$snake_cache[ $key ][ $separator ] ) ) {
			return static::$snake_cache[ $key ][ $separator ];
		}

		$value = $input;
		if ( ! function_exists( 'ctype_lower' ) || ! ctype_lower( $input ) ) {
			$value = preg_replace( '/\s+/u', '', ucwords( $input ) );
			$value = mb_strtolower( preg_replace( '/(.)(?=[A-Z])/u', '$1' . $separator, $value ), 'UTF-8' );
		}
        static::$snake_cache[ $key ][ $separator ] = $value;
		return $value;
	}

    /**
     * Convert a value to boolean.
     *
     * @param string|int|mixed $input The string/value to convert to a boolean.
     * @return bool
     */
	public static function to_bool( $input ): bool {
        return filter_var( $input, FILTER_VALIDATE_BOOLEAN );
	}
}
