<?php

namespace GoodWP\Altinator\Vendor\GoodWP\Common\Helper;

/**
 * A collection of helper functions to work with WP_Query instances.
 */
abstract class Query {

    /**
     * Applies a sub-query to an existing (maybe nested) query like 'meta_query' or 'tax_query'.
     *
     * @param array      $new_query The new (sub-)query to apply.
     * @param array|null $old_query The existing query/queries.
     * @param 'AND'|'OR' $relation Relation to combine the two queries.
     * @return array{'relation':string,0:array,1:array}|array
     */
    public static function apply_sub_query( array $new_query, ?array $old_query = null, string $relation = 'AND' ): array {
        if ( empty( $old_query ) ) {
            return [ $new_query ];
        }

        return [
            'relation' => $relation,
            $new_query,
            (array) $old_query,
        ];
    }
}
