<?php

namespace GoodWP\Altinator\Vendor\GoodWP\Common\Helper;

/**
 * Helpers for form elements.
 *
 * @package GoodWP\Common\Helper
 */
abstract class Form {

    /**
     * Input format for datetime inputs.
     *
     * @var string
     */
	public const DATETIME_INPUT_FORMAT = 'Y-m-d\TH:i';

    /**
     * Whether a value is selected in a <select> input.
     * A wrapper around WordPress core select but allows for multiple selected values.
     *
     * @param int|string|array $selected_value The selected value to check. Can be an array.
     * @param int|string|array $option_value The current value to compare against. Can be an array.
     * @param bool             $display Whether to echo or return the result.
     * @return string
     */
	public static function selected( $selected_value, $option_value, $display = true ) {
		if ( is_array( $selected_value ) ) {
			$is_selected = in_array( $option_value, $selected_value ); //phpcs:ignore WordPress.PHP.StrictInArray.MissingTrueStrict
			return selected( $is_selected, true, $display );
		}
		return selected( $selected_value, $option_value, $display );
	}

    /**
     * A helper for outputting a required-html attribute to form elements.
     *
     * @param bool $required Whether the element is required or not. Will be evaluated to boolean.
     * @param bool $display Whether to echo or return the result.
     * @return string
     */
	public static function required( $required, $display = true ) {
		return __checked_selected_helper( $required, true, $display, 'required' );
	}
}
