<?php

namespace GoodWP\Altinator\Vendor\GoodWP\Common\Helper;

use Closure;

/**
 * Collection of array helper functions.
 */
abstract class Arr {

    /**
     * Transform an array of HTML attributes to a string of rendered and escaped attributes.
     *
     * @param array<string,string|bool> $attributes Array of HTML attributes.
     * @return string
     */
	public static function html_attributes( array $attributes ): string {
        $boolean_attributes = [ 'required', 'disabled', 'readonly', 'checked', 'selected' ];

		return implode(
			' ',
			array_map(
				function ( $key, $value ) use ( $boolean_attributes ) {
                    if ( in_array( $key, $boolean_attributes, true ) && ! $value ) {
                        return '';
                    }
					return sprintf( '%s="%s"', $key, esc_attr( $value ) );
				},
				array_keys( $attributes ),
				array_values( $attributes )
			)
		);
	}

    /**
     * Merges two arrays of HTML attributes. Attributes that can be combined (like style and class) are appended.
     *
     * @param array<string,string|bool> $attributes The attributes to merge in. Will overwrite values in $original (except combinable).
     * @param array<string,string|bool> $original The original / base attributes.
     * @return array
     */
	public static function merge_html_attributes( array $attributes, array $original ): array {
		$attributes_to_merge = [ 'style', 'class' ];

		$merged_attrs = array_merge( $original, $attributes );

		foreach ( $attributes_to_merge as $attr ) {
			if ( isset( $attributes[ $attr ] ) && isset( $original[ $attr ] ) ) {
				$merged_attrs[ $attr ] = $original[ $attr ] . ' ' . $attributes[ $attr ];
			}
		}

		return $merged_attrs;
	}
}
