<?php

namespace GoodWP\Altinator\Vendor\GoodWP\Common\Exceptions;

use Exception;

/**
 * An exception for singletons and other classes, where an instance an be expected.
 *
 * @package GoodWP\Common\Exceptions
 */
class No_Instance_Exception extends Exception {

    /**
     * Constructs the exception.
     *
     * @param string $class_name The name of the class which had no instance.
     * @return void
     */
	public function __construct( string $class_name ) {
		parent::__construct( 'No instance of ' . $class_name . ' initialized / set yet.' );
	}
}
