<?php

namespace GoodWP\Altinator\Vendor\GoodWP\Common\Events;

/**
 * A no-op Event_Manager doing nothing, but can be used as a replacement where event manager is needed.
 *
 * @package GoodWP\Common\Events
 */
class No_Op_Event_Manager implements Event_Manager_Contract {
    /**
     * {@inheritDoc}
     */
	public function add_filter( string $hook_name, callable $callback, int $priority = 10, int $accepted_args = 1 ): bool {
		return true;
	}

    /**
     * {@inheritDoc}
     */
	public function apply_filters( string $hook_name, mixed $value, ...$args ): mixed {
        return $value;
	}

    /**
     * {@inheritDoc}
     */
	public function has_filter( string $hook_name, callable|false $callback = false ): bool {
		return false;
	}

    /**
     * {@inheritDoc}
     */
	public function remove_filter( string $hook_name, callable $callback, int $priority = 10 ): bool {
		return true;
	}

    /**
     * {@inheritDoc}
     */
	public function remove_all_filters( string $hook_name, int|false $priority = false ): bool {
		return true;
	}

    /**
     * {@inheritDoc}
     */
	public function add_action( string $hook_name, callable $callback, int $priority = 10, int $accepted_args = 1 ): bool {
		return true;
	}

    /**
     * {@inheritDoc}
     */
	public function do_action( string $hook_name, ...$args ): void {
	}

    /**
     * {@inheritDoc}
     */
	public function has_action( string $hook_name, callable|false $callback = false ): bool {
		return false;
	}

    /**
     * {@inheritDoc}
     */
	public function remove_action( string $hook_name, callable $callback, int $priority = 10 ): bool {
		return true;
	}

    /**
     * {@inheritDoc}
     */
	public function remove_all_actions( string $hook_name, int|false $priority = false ): bool {
		return true;
	}
}
