<?php

namespace GoodWP\Altinator\Vendor\GoodWP\Common\Events;

trait Has_Events {
    /**
     * The injected event manager instance to use.
     *
     * @var null|Event_Manager_Contract
     */
    protected ?Event_Manager_Contract $event_manager = null;

    /**
     * Gets the event manager instance
     *
     * @return Event_Manager_Contract|null
     */
    public function get_event_manager(): ?Event_Manager_Contract {
        return $this->event_manager;
    }

    /**
     * Sets the Event_Manager_Contract instance to use.
     *
     * @param Event_Manager_Contract|null $event_manager The event manager to use.
     * @return void
     */
    public function set_event_manager( ?Event_Manager_Contract $event_manager ): void {
        if ( ! $event_manager ) {
            $event_manager = new No_Op_Event_Manager();
        }
        $this->event_manager = $event_manager;
    }
}
