<?php

namespace GoodWP\Altinator\Vendor\GoodWP\Common\Events;

/**
 * An Event_Manager using WordPress hook system and a prefix for all hooks names.
 *
 * @package GoodWP\Common\Events
 */
class Event_Manager implements Event_Manager_Contract {

    /**
     * Creates a new Event_Manager instance with a prefix for all hooks.
     *
     * @param string $prefix  A prefix to use for all hook names. Should include a trailing slash.
     * @return void
     */
	public function __construct( public readonly string $prefix ) {
        assert( str_ends_with( $this->prefix, '/' ) );
	}

    /**
     * {@inheritDoc}
     */
	public function add_filter( string $hook_name, callable $callback, int $priority = 10, int $accepted_args = 1 ): bool {
		return add_filter(
			"{$this->prefix}{$hook_name}",
			$callback,
			$priority,
			$accepted_args
		);
	}

    /**
     * {@inheritDoc}
     */
	public function apply_filters( string $hook_name, mixed $value, ...$args ): mixed {
        // phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.DynamicHooknameFound
		return apply_filters( "{$this->prefix}{$hook_name}", $value, ...$args );
	}

    /**
     * {@inheritDoc}
     */
	public function has_filter( string $hook_name, callable|false $callback = false ): bool {
		return has_filter( "{$this->prefix}{$hook_name}", $callback );
	}

    /**
     * {@inheritDoc}
     */
	public function remove_filter( string $hook_name, callable $callback, int $priority = 10 ): bool {
		return remove_filter( "{$this->prefix}{$hook_name}", $callback, $priority );
	}

    /**
     * {@inheritDoc}
     */
	public function remove_all_filters( string $hook_name, int|false $priority = false ): bool {
		return remove_all_filters( "{$this->prefix}{$hook_name}", $priority );
	}

    /**
     * {@inheritDoc}
     */
	public function add_action( string $hook_name, callable $callback, int $priority = 10, int $accepted_args = 1 ): bool {
		return add_action(
			"{$this->prefix}{$hook_name}",
			$callback,
			$priority,
			$accepted_args
		);
	}

    /**
     * {@inheritDoc}
     */
	public function do_action( string $hook_name, ...$args ): void {
        //phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.DynamicHooknameFound
		do_action( "{$this->prefix}{$hook_name}", ...$args );
	}

    /**
     * {@inheritDoc}
     */
	public function has_action( string $hook_name, callable|false $callback = false ): bool {
		return has_action( "{$this->prefix}{$hook_name}", $callback );
	}

    /**
     * {@inheritDoc}
     */
	public function remove_action( string $hook_name, callable $callback, int $priority = 10 ): bool {
		return remove_action( "{$this->prefix}{$hook_name}", $callback, $priority );
	}

    /**
     * {@inheritDoc}
     */
	public function remove_all_actions( string $hook_name, int|false $priority = false ): bool {
		return remove_all_actions( "{$this->prefix}{$hook_name}", $priority );
	}
}
