<?php

namespace GoodWP\Altinator\Vendor\GoodWP\Common\Errors;

use Exception;

/**
 * Adds setter and (protected) getter for the setter-injection of the Error_Collector service.
 */
trait Has_Errors {
    /**
     * The injected error instance to use
     *
     * @var Error_Collector_Contract|null
     */
    protected ?Error_Collector_Contract $error_collector = null;

    /**
     * Gets the error collector instance
     *
     * @return Error_Collector_Contract
     * @throws Exception If no error collector has been set.
     */
    protected function get_error_collector(): Error_Collector_Contract {
        if ( $this->error_collector ) {
            return $this->error_collector;
        }

        throw new Exception( 'No Error Collector set.' );
    }

    /**
     * Sets the Error_Collector_Contract instance to use.
     *
     * @param Error_Collector_Contract|null $error_collector The error collector to use.
     * @return void
     */
    public function set_error_collector( ?Error_Collector_Contract $error_collector ): void {
        $this->error_collector = $error_collector;
    }
}
