<?php

namespace GoodWP\Altinator\Vendor\GoodWP\Common\Errors;

use WP_Error;

/**
 * A service to collect errors and display them.
 */
interface Error_Collector_Contract {
    /**
     * Add an error to the collection.
     *
     * @param WP_Error $error The error to add.
     * @param string   $context The context of the error.
     * @return void
     */
    public function add_error( WP_Error $error, string $context ): void;

    /**
     * Whether the collection has errors for a specific context.
     *
     * @param string|null $context The context to check for.
     * @return bool
     */
    public function has_errors( ?string $context = null ): bool;

    /**
     * Whether the collection has errors for a specific error code
     * optionally checks only a specific context.
     *
     * @param string      $error_code The error code to check for.
     * @param string|null $context An optional context to check for.
     * @return bool
     */
    public function has_error_code( string $error_code, ?string $context = null ): bool;

    /**
     * Get all errors for a context.
     *
     * @param string $context The context to get errors for.
     * @return WP_Error[]
     */
    public function get_errors( string $context ): array;

    /**
     * Get all errors for all contexts.
     *
     * @return array<string, WP_Error[]>
     */
    public function get_all_errors(): array;
}
