<?php

namespace GoodWP\Altinator\Vendor\GoodWP\Common\DI;

use GoodWP\Altinator\Vendor\GoodWP\Common\Contracts\Bootable;
use GoodWP\Altinator\Vendor\lucatume\DI52\ContainerException;
use GoodWP\Altinator\Vendor\lucatume\DI52\ServiceProvider as Base_Service_Provider;

/**
 * An abstract Base Service Provider extending DI52's ServiceProvider.
 *
 * @package GoodWP\Common\DI
 */
abstract class Service_Provider extends Base_Service_Provider implements Bootable {

    /**
	 * The container instance.
     *
     * @var Container
	 */
	protected $container;

	/**
	 * Registers the service provider bindings.
	 *
     * @throws ContainerException If the binding fails.
	 * @return void The method does not return any value.
	 */
	abstract public function register(): void;

	/**
	 * Use this to boot your services (eg add hooks in the services boot method)
	 * Or directly add hooks to instance methods of services here with the containers `callback` helper.
	 *
	 * If you want to prevent eager instantiation (= generating an instance for your service, just for adding hooks)
	 * Instead add hooks here via the containers `callback` helper.
	 *
	 * @link https://github.com/lucatume/DI52#the-callback-method
	 *
	 * Each Service Provider has to override this method, so it's called in container's boot.
	 *
	 * @return void The method will not return any value.
	 */
	public function boot(): void {
        // no-op.
    }
}
