<?php
/**
 * The Dependency Injection container.
 *
 * @package GoodWP\Common\DI
 */

namespace GoodWP\Altinator\Vendor\GoodWP\Common\DI;

use GoodWP\Altinator\Vendor\lucatume\DI52\Container as Base_Container;
use GoodWP\Altinator\Vendor\lucatume\DI52\ContainerException;

/**
 * Container extending DI52s container with some helper methods.
 */
class Container extends Base_Container {

    /**
     * A map of aliases.
     *
     * @var array<string,string>
     */

    protected array $aliases = [];

    /**
     * Register an alias for a bound service/variable.
     *
     * @param string              $alias The alias under which to provide the binding.
     * @param string|class-string $id A class or interface fully qualified name or a string slug.
     * @return void
     * @throws ContainerException If there's an issue while trying to bind the implementation.
     */
    public function alias( string $alias, string $id ): void {
        $this->aliases[ $alias ] = $id;
        // Bind callback function as factory, not as singleton. But $container->get will then correctly get the bound value as variable, singleton, etc.
        // as configured in the original $id.
        $this->bind( $alias, fn( self $container ) => $container->get( $id ) );
    }
}
