<?php

namespace GoodWP\Altinator\Vendor\GoodWP\Common\Assets;

use Exception;

/**
 * Adds setter and (protected) getter for the setter-injection of the Asset_Manager_Contract
 */
trait Has_Assets {
	/**
	 * The injected asset manager instance to use
	 *
	 * @var Asset_Manager_Contract|null
	 */
	protected ?Asset_Manager_Contract $asset_manager = null;

	/**
	 * Gets the asset manager instance
	 *
	 * @return Asset_Manager_Contract
     * @throws Exception If no asset manager has been set.
	 */
	protected function get_asset_manager(): Asset_Manager_Contract {
		if ( $this->asset_manager ) {
			return $this->asset_manager;
		}

		throw new Exception( 'No Asset Manager set.' );
	}

    /**
     * Sets the Asset_Manager_Contract instance to use.
     *
     * @param Asset_Manager_Contract|null $asset_manager The asset manager to use.
     * @return void
     */
	public function set_asset_manager( ?Asset_Manager_Contract $asset_manager ): void {
		$this->asset_manager = $asset_manager;
	}
}
