<?php

namespace GoodWP\Altinator\Vendor\GoodWP\Common\Assets;

interface Block_Asset_Manager_Contract {

    /**
     * Returns the path to a blocks block.json file.
     *
     * @param string $block_name The block name, as it's directory/built asset folder is called.
     * @return string The full path to the block.json file.
     */
    public function get_block_file_path( string $block_name ): string;

    /**
     * Parse an asset manifest built via @wordpress/scripts.
     *
     * @param string $handle The script handle.
     * @param string $file The file path.
     * @return array Parsed data containing dependencies and version.
     */
    public function parse_asset_file( string $handle, string $file ): array;
}
