<?php

namespace GoodWP\Altinator\Vendor\GoodWP\Admin\Taxonomies;

use GoodWP\Altinator\Vendor\GoodWP\Admin\Screens\List_Table_Screen;
use GoodWP\Altinator\Vendor\GoodWP\Common\Helper\Str;
use WP_Term;

abstract class Taxonomy_List_Screen extends List_Table_Screen {

    // TODO: Implement filters for taxonomy list screen.

    /**
     * The taxonomy
     *
     * @var string
     */
    protected const SCREEN_ID = '';

    public function boot(): void {
        parent::boot();
        add_action( 'load-edit-tags.php', [ $this, 'load' ] );
    }

    public function load(): void {
        parent::load();
        if ( $this->is_current_screen() ) {
            add_filter( 'manage_' . static::SCREEN_ID . '_custom_column', [ $this, 'render_column' ], 10, 3 );
            add_filter( 'tag_row_actions', [ $this, 'maybe_row_actions' ], 10, 2 );
        }
    }

    /**
     * Render individual columns.
     *
     * @param string $output Default empty string.
     * @param string $column Column ID to render.
     * @param int    $post_id Post ID being shown.
     */
    public function render_column( $output, string $column, int $post_id ) {
        $function = 'render_' . Str::snake( $column ) . '_column';
        if ( is_callable( [ $this, $function ] ) ) {
            $this->$function( $post_id );
        }
    }

    /**
     * Set row actions.
     *
     * @param array   $actions Array of actions.
     * @param WP_Term $term Current term object.
     * @return array
     */
    public function maybe_row_actions( array $actions, WP_Term $term ): array {
        if ( static::SCREEN_ID === $term->taxonomy ) {
            return $this->row_actions( $actions, $term );
        }
        return $actions;
    }

    /**
     * Get row actions to show in the list table.
     *
     * @param array   $actions Array of actions.
     * @param WP_Term $term Current term object.
     * @return array
     */
    protected function row_actions( array $actions, WP_Term $term ): array {
        return $actions;
    }

    public function is_current_screen(): bool {
        $is_current_screen = parent::is_current_screen();
        if ( ! $is_current_screen ) {
            return false;
        }
        $current_screen = get_current_screen();

        return $current_screen && $current_screen->taxonomy === static::SCREEN_ID;
    }
}
