<?php

namespace GoodWP\Altinator\Vendor\GoodWP\Admin\Taxonomies;

use GoodWP\Altinator\Vendor\GoodWP\Admin\Screens\Admin_Screen;
use WP_Term;

abstract class Taxonomy_Edit_Screen extends Admin_Screen {

    protected const TAXONOMY = '';

    public function boot(): void {
        assert( ! empty( static::TAXONOMY ), 'TAXONOMY constant must be set on ' . static::class );

        $this->screen_id = static::TAXONOMY;

        add_action( 'load-term.php', [ $this, 'load' ] );
        add_action( 'load-edit-tags.php', [ $this, 'load' ] );
    }

    public function load(): void {
        if ( $this->is_current_screen() ) {
            add_action( static::TAXONOMY . '_add_form_fields', [ $this, 'display_fields' ] );
            add_action( static::TAXONOMY . '_edit_form_fields', [ $this, 'display_fields' ] );

            add_action( 'created_' . static::TAXONOMY, [ $this, 'save_taxonomy' ] );
            add_action( 'edited_' . static::TAXONOMY, [ $this, 'save_taxonomy' ] );

            $this->init_fields();
        }
    }

    public function is_current_screen(): bool {
        if ( ! is_admin() ) {
            return false;
        }

        $current_screen = get_current_screen();
        return $current_screen &&
            $current_screen->taxonomy === static::TAXONOMY;
    }

    abstract protected function init_fields(): void;
    /**
     * Undocumented function
     *
     * @param string|WP_Term $term_or_taxonomy A WP_Term instance on editing, the taxonomy as string on creating a new.
     * @return void
     */
    abstract public function display_fields( $term_or_taxonomy ): void;
    abstract public function save_taxonomy( int $term_id ): void;
}
