<?php

namespace GoodWP\Altinator\Vendor\GoodWP\Admin\Screens;

abstract class List_Table_Screen extends Admin_Screen {

    /**
     * The post type
     *
     * @var string
     */
    protected const SCREEN_ID = '';

    /**
     * {@inheritDoc}
     */
    public function boot(): void {
        assert( ! empty( static::SCREEN_ID ), 'SCREEN_ID constant must be set on ' . static::class );
    }

    public function load(): void {
        if ( $this->is_current_screen() ) {
            add_filter( 'bulk_actions-edit-' . static::SCREEN_ID, [ $this, 'bulk_actions' ] );
            add_filter( 'handle_bulk_actions-edit-' . static::SCREEN_ID, [ $this, 'handle_bulk_actions' ], 10, 3 );

            add_filter( 'manage_edit-' . static::SCREEN_ID . '_columns', [ $this, 'columns' ] );

            add_filter( 'manage_edit-' . static::SCREEN_ID . '_sortable_columns', [ $this, 'sortable_columns' ] );
        }
    }

    /**
     * Handle bulk actions.
     *
     * TODO: handle single/bulk deletion in admin
     *
     * @param  string $redirect_to URL to redirect to.
     * @param  string $action      Action name.
     * @param  array  $ids         List of ids.
     * @return string
     */
    public function handle_bulk_actions( $redirect_to, $action, $ids ): string {
        return $redirect_to;
    }

    /**
     * Define bulk actions.
     *
     * @param array $actions Existing actions.
     * @return array
     */
    public function bulk_actions( array $actions ): array {
        return $actions;
    }

    /**
     * Define which columns to show on this screen.
     *
     * @param array $columns Existing columns.
     * @return array
     */
    public function columns( array $columns ): array {
        return $columns;
    }

    /**
     * Define which columns are sortable
     *
     * @param array $columns Existing sortable columns.
     * @return array
     */
    public function sortable_columns( array $columns ): array {
        return $columns;
    }

    public function is_current_screen(): bool {
        if ( ! is_admin() ) {
            return false;
        }

        $current_screen = get_current_screen();
        return $current_screen &&
            $current_screen->id === 'edit-' . static::SCREEN_ID;
    }
}
