<?php

namespace GoodWP\Altinator\Vendor\GoodWP\Admin\Screens;

use GoodWP\Altinator\Vendor\GoodWP\Common\Contracts\Bootable;

/**
 * An abstract base class for admin screens.
 *
 * @package GoodWP\Altinator\Vendor\GoodWP\Admin\Screens
 */
abstract class Admin_Screen implements Bootable {

    /**
     * Referes to the $screen->id variable from WordPress
     * eg post type or taxonomy.
     *
     * @var string
     */
    protected string $screen_id = '';

    /**
     * Boots up this screen. Will always be called (regardless if current screen or not).
     * Should/can:
     *  - register any hooks that must happen on all requests (e.g. ajax)
     *  - add a hook to register the screen
     *  - add load-$page hook
     *  - add hooks to wp_enqueue_scripts
     *
     * @return void
     */
    abstract public function boot(): void;

    /**
     * Load a screen
     * Should be called on WordPress "load-$page" hook, when the currentScreen is set.
     *
     * @link https://developer.wordpress.org/reference/hooks/load-page-php/
     *
     * @return void
     */
    abstract public function load(): void;

    /**
     * Whether this screen represents the current screen.
     *
     * @return bool
     */
    public function is_current_screen(): bool {
        if ( ! is_admin() ) {
            return false;
        }

        $current_screen = get_current_screen();
        return $current_screen &&
            $current_screen->id === $this->screen_id;
    }
}
