<?php

namespace GoodWP\Altinator\Vendor\GoodWP\Admin\Posts\Lists;

use GoodWP\Altinator\Vendor\GoodWP\Admin\Posts\Lists\Post_List_Filter;
use GoodWP\Altinator\Vendor\GoodWP\Common\Helper\Sanitize;
use RuntimeException;

trait With_Filters {

    // TODO: apply filters / map to query? - use datastore query map -
    // screens should only work with post type datastore, not others - that's out of scope.

    /**
     * @return void
     * @throws RuntimeException If an invalid filter is registered.
     */
    protected function render_post_filters(): void {
        $filters = $this->get_filters();

        foreach ( $filters as $name => $config ) {
            assert( ! empty( $config['type'] ), 'filter type not set' );

            $type = $config['type'];
            if ( ! isset( $this->post_list_filters[ $type ] ) ) {
                throw new RuntimeException( $config['type'] . ' filter type does not exist or is not registered.' );
            }

            $filter_class = $this->post_list_filters[ $type ];
            if ( ! class_exists( $filter_class ) || ! is_subclass_of( $filter_class, Post_List_Filter::class ) ) {
                throw new RuntimeException(
                    $filter_class . ' does not exist or does not impelement ' . Post_List_Filter::class . '.'
                );
            }
            /** @var Post_List_Filter */

            $filter = new $filter_class( $name, $config, $this->get_current_filter_value( $name, $config ) );
            $filter->render();
        }
    }

    protected function get_current_filter_value( string $filter_name, array $filter_config ) {
        if ( array_key_exists( $filter_name, $this->current_filter_values ) ) {
            return $this->current_filter_values[ $filter_name ];
        }
        if ( array_key_exists( 'default', $filter_config ) ) {
            return $filter_config['default'];
        }
        return null;
    }

    protected function parse_filter_values_from_query( ?array $query = null ) {
        if ( ! $query ) {
            $query = $_GET;
        }

        $filters = $this->get_filters();
        $values  = [];
        foreach ( $filters as $name => $config ) {
            if ( isset( $query[ $name ] ) ) {
                $values[ $name ] = Sanitize::sanitize( $query[ $name ] );
            }
        }
        return $values;
    }
}
