<?php

namespace GoodWP\Altinator\Vendor\GoodWP\Admin\Posts\Lists;

abstract class Post_List_Filter {

    protected array $config;

    public function __construct(
        protected string $name,
        array $config,
        protected $current_filter_value
	) {
        $this->config = $config; // So getDefaultConfig has access.
        $this->config = wp_parse_args( $config, $this->get_default_config() );
    }

    protected function get_default_config(): array {
        return [];
    }

    abstract public function render(): void;
}
