<?php

namespace GoodWP\Altinator\Vendor\GoodWP\Admin\Posts\Lists\Filters;

use GoodWP\Altinator\Vendor\GoodWP\Admin\Posts\Lists\Post_List_Filter;

class Taxonomy_Filter extends Post_List_Filter {

    protected function get_default_config(): array {
        $taxonomy        = $this->config['taxonomy'];
        $taxonomy_object = get_taxonomy( $taxonomy );

        $key = $this->config['query_var'] ?? $this->name;
        $id = $this->config['id'] ?? 'filter_' . $this->name;

        return [
            'hide_empty' => 1,
            'show_count' => 0,
            'name'       => $key,
            'label'      => '<label class="screen-reader-text" for="' . $id . '">'
                . $taxonomy_object->labels->filter_by_item . '</label>',
            'dropdown'   => [],
        ];
    }

    public function render(): void {
        $taxonomy        = $this->config['taxonomy'];
        $taxonomy_object = get_taxonomy( $taxonomy );

        $key = $this->config['query_var'] ?? $this->name;
        $id = $this->config['id'] ?? 'filter_' . $this->name;

        $dropdown_options = wp_parse_args(
            $this->config['dropdown'],
            [
				'id'                => $id,
				'hierarchical'      => $taxonomy_object->hierarchical,
				'show_option_all'   => $taxonomy_object->labels->all_items,
				'show_option_none'  => sprintf(
					/* translators: taxonomy name */
					__( 'Without %s', 'goodwp-admin' ),
					$taxonomy_object->labels->singular_name
				),
				'option_none_value' => '',
				'hide_if_empty'     => true,
				'orderby'           => 'name',
				'taxonomy'          => $this->config['taxonomy'],
				'selected'          => $this->current_filter_value,
				'value_field'       => 'slug',
			]
        );

        $dropdown_options['name'] = $key;

        echo wp_kses(
            $this->config['label'],
            [
				'label' => [
					'class' => true,
					'for'   => true,
				],
				'span'  => [ 'class' => true ],
			]
        );

        wp_dropdown_categories( $dropdown_options );
    }
}
