<?php

namespace GoodWP\Altinator\Vendor\GoodWP\Admin\Posts\Lists\Filters;

use GoodWP\Altinator\Vendor\GoodWP\Admin\Posts\Lists\Post_List_Filter;
use GoodWP\Altinator\Vendor\GoodWP\Common\Helper\Form;

class Select_Filter extends Post_List_Filter {

    protected function get_default_config(): array {
        return [
            'options' => [],
            'name'    => $this->name,
            'label'   => __( 'Filter', 'goodwp-admin' ),
        ];
    }

    public function render(): void {
        $options = $this->config['options'];
        if ( is_callable( $options ) ) {
            // @phpstan-ignore  WPCompat.error (Throws some parser error)
            $options = $this->config['options']();
        }

        $key = $this->config['query_var'] ?? $this->name;
        $id = $this->config['id'] ?? 'filter_' . $this->config['name']; ?>
        <label class="screen-reader-text" for="<?php echo esc_attr( $id ); ?>">
            <?php echo esc_html( $this->config['label'] ); ?>
        </label>
        <select id="<?php echo esc_attr( $id ); ?>" class="postform" name="<?php echo esc_attr( $key ); ?>">
            <?php
            foreach ( $options as $key => $value ) {
                if ( is_array( $value ) ) {
                    printf(
                        '<option value="%1$s" %2$s >%3$s</option>',
                        esc_attr( $value['value'] ),
                        // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped -- Form::selected uses selected which is escaped.
                        Form::selected( $this->current_filter_value, $value['value'] ),
                        esc_html( $value['label'] )
                    );
                } else {
                    printf(
                        '<option value="%1$s" %2$s >%3$s</option>',
                        esc_attr( $key ),
                        // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped -- Form::selected uses selected which is escaped.
                        Form::selected( $this->current_filter_value, $key ),
                        esc_html( $value )
                    );
                }
            }
            ?>
        </select>
		<?php
    }
}
