<?php

namespace GoodWP\Altinator\Vendor\GoodWP\Admin\Posts;

use GoodWP\Altinator\Vendor\GoodWP\Admin\Screens\Admin_Screen;
use WP_Post;

abstract class Classic_Post_Edit_Screen extends Admin_Screen {

    /**
     * The post type
     *
     * @var string
     */
    protected const POST_TYPE = '';

    /**
     * Undocumented variable
     *
     * @var Meta_Box[]
     */
    protected array $meta_boxes = [];

    /**
     * Creates a new screen instance.
     */
    public function __construct() {
        assert( ! empty( static::POST_TYPE ), 'POST_TYPE constant must be set on ' . static::class );
        $this->screen_id = static::POST_TYPE;
    }

    public function boot(): void {

        if ( use_block_editor_for_post_type( static::POST_TYPE ) ) {
            return;
        }

        add_action( 'load-post.php', [ $this, 'load' ] );
        add_action( 'load-post-new.php', [ $this, 'load' ] );
    }

    public function load(): void {
        $this->register_assets();
        if ( $this->is_current_screen() ) {
            add_action( 'add_meta_boxes', [ $this, 'register_meta_boxes' ] );
            add_action( 'save_post_' . static::POST_TYPE, [ $this, 'save_post' ], 10, 3 );
        }
    }

    /**
     * Registers all the assets for the block editor.
     * Do this on all screens, because with site-editor/page-editor,
     * user could load a different post type, but then switch to event.
     *
     * @return void
     */
    protected function register_assets(): void {
    }

    public function is_current_screen(): bool {
        if ( ! is_admin() ) {
            return false;
        }

        assert( ! empty( $this->screen_id ), 'screen_id constant must be set to post type on ' . static::class );

        $current_screen = get_current_screen();
        return $current_screen &&
            $current_screen->id === $this->screen_id &&
            $current_screen->post_type === static::POST_TYPE &&
            ! $current_screen->is_block_editor();
    }

    abstract protected function register_meta_boxes(): void;
    abstract public function display_meta_box( ?WP_Post $post, array $args );

    /**
     * Handle saving your custom meta boxes and fields here.
     *
     * @param int     $post_id
     * @param WP_Post $post
     * @param bool    $update
     * @return void
     */
    public function save_post( int $post_id, WP_Post $post, bool $update ) {
    }
}
