<?php

namespace GoodWP\Altinator\Vendor\GoodWP\Admin;

use GoodWP\Altinator\Vendor\GoodWP\Admin\Screens\Admin_Screen;
use GoodWP\Altinator\Vendor\GoodWP\Common\DI\Container;

abstract class Abstract_Admin_Service {

    /**
     * All screens.
     * Classes must extend Admin_Screen
     *
     * @var class-string<Admin_Screen>[]
     */
    protected array $screens = [];

    public function __construct( protected Container $container ) {
    }

    public function boot_screens() {
        foreach ( $this->screens as $screen ) {
            $screen_instance = $this->container->get( $screen );
            if ( $screen_instance ) {
                $screen_instance->boot();
            }
        }
    }
}
