<?php
/**
 * Meta box template
 *
 * @package AltAudit
 * @since 1.0.0
 */

// Prevent direct access.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// Variables available: $post (WP_Post), $images (array with 'attached' and 'in_content').

// phpcs:disable WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound -- Template variables.
$altaudit82ai_attached_images = $images['attached'];
$altaudit82ai_content_images  = $images['in_content'];
// phpcs:enable WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound
?>

<div class="alt-audit-meta-box">
	<div class="alt-audit-section">
		<h4><?php esc_html_e( 'Attached Images', 'alt-audit' ); ?></h4>
		<?php if ( empty( $altaudit82ai_attached_images ) ) : ?>
			<p><em><?php esc_html_e( 'No images attached to this post.', 'alt-audit' ); ?></em></p>
		<?php else : ?>
			<ul class="alt-audit-image-list">
				<?php foreach ( $altaudit82ai_attached_images as $altaudit82ai_image ) : // phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound -- Template loop variable. ?>
					<?php
					// phpcs:disable WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound -- Template variables.
					$altaudit82ai_alt_text = get_post_meta( $altaudit82ai_image->ID, '_wp_attachment_image_alt', true );
					$altaudit82ai_has_alt  = ! empty( $altaudit82ai_alt_text );
					// phpcs:enable WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound
					?>
					<li class="alt-audit-image-item">
						<div class="image-preview">
							<?php
							echo wp_kses_post(
								wp_get_attachment_image(
									$altaudit82ai_image->ID,
									'thumbnail',
									false,
									array(
										'style' => 'max-width: 50px; height: auto;',
										'alt'   => '',
									)
								)
							);
							?>
						</div>
						<div class="image-details">
							<strong><?php echo esc_html( $altaudit82ai_image->post_title ); ?></strong>
							<div class="alt-status">
								<?php if ( $altaudit82ai_has_alt ) : ?>
									<span class="dashicons dashicons-yes" style="color: green;"></span>
									<span
										class="alt-text-preview"><?php echo esc_html( mb_strimwidth( $altaudit82ai_alt_text, 0, 50, '...' ) ); ?></span>
								<?php else : ?>
									<span class="dashicons dashicons-warning" style="color: orange;"></span>
									<span class="missing-alt"><?php esc_html_e( 'Missing Alt Text', 'alt-audit' ); ?></span>
								<?php endif; ?>
							</div>
							<a href="<?php echo esc_url( get_edit_post_link( $altaudit82ai_image->ID ) ); ?>" target="_blank"
								class="button button-small">
								<?php esc_html_e( 'Edit', 'alt-audit' ); ?>
							</a>
						</div>
					</li>
				<?php endforeach; ?>
			</ul>
		<?php endif; ?>
	</div>

	<?php if ( ! empty( $altaudit82ai_content_images ) ) : ?>
		<div class="alt-audit-section" style="margin-top: 15px; border-top: 1px solid #eee; padding-top: 10px;">
			<h4><?php esc_html_e( 'Images in Content', 'alt-audit' ); ?></h4>
			<p>
			<?php
			// translators: %d is the number of images found in the content.
			printf( esc_html__( 'Found %d images embedded in the content.', 'alt-audit' ), count( $altaudit82ai_content_images ) );
			?>
			</p>
		</div>
	<?php endif; ?>
</div>