<?php
/**
 * Template for attachment field in media library
 *
 * @var int    $attachment_id Attachment ID
 * @var string $alt_text      Current alt text
 * @var array  $quality       Quality assessment results
 *
 * @package Altaudit82ai
 */

// Prevent direct access.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
?>

<div class="alt-audit-field">
	<div class="alt-audit-current-alt">
		<label for="alt-audit-alt-text-<?php echo esc_attr( $attachment_id ); ?>">
			<strong><?php esc_html_e( 'Current Alt Text:', 'alt-audit' ); ?></strong>
		</label>
		<p id="alt-audit-alt-text-<?php echo esc_attr( $attachment_id ); ?>" class="alt-audit-alt-text">
			<?php echo esc_html( $alt_text ? $alt_text : __( 'No alt text set', 'alt-audit' ) ); ?>
		</p>
	</div>

	<?php if ( $quality ) : ?>
	<div class="alt-audit-quality-score">
		<strong><?php esc_html_e( 'Quality Score:', 'alt-audit' ); ?></strong>
		<span class="alt-audit-score alt-audit-score-<?php echo esc_attr( strtolower( $quality['level'] ?? 'unknown' ) ); ?>">
			<?php echo esc_html( $quality['score'] ?? 0 ); ?>%
			(<?php echo esc_html( $quality['level'] ?? __( 'Unknown', 'alt-audit' ) ); ?>)
		</span>
	</div>
	<?php endif; ?>

	<div class="alt-audit-actions">
		<button type="button"
				class="button alt-audit-generate-ai-btn"
				data-attachment-id="<?php echo esc_attr( $attachment_id ); ?>"
				data-action="generate_ai">
			<?php esc_html_e( 'AI Alt Generation', 'alt-audit' ); ?>
		</button>
		<button type="button"
				class="button alt-audit-generate-rule-btn"
				data-attachment-id="<?php echo esc_attr( $attachment_id ); ?>"
				data-action="generate_rule">
			<?php esc_html_e( 'Rule-based Generation', 'alt-audit' ); ?>
		</button>
		<button type="button"
				class="button alt-audit-audit-quality-btn"
				data-attachment-id="<?php echo esc_attr( $attachment_id ); ?>"
				data-action="audit_quality">
			<?php esc_html_e( 'Audit Quality', 'alt-audit' ); ?>
		</button>
	</div>

	<div class="alt-audit-loading" style="display: none;">
		<p><?php esc_html_e( 'Processing...', 'alt-audit' ); ?></p>
	</div>
</div>