<?php
/**
 * Admin Settings Template
 *
 * @package AltAudit
 * @since 1.0.0
 */

// Prevent direct access.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$altaudit82ai_settings         = altaudit82ai()->get_service( 'settings' ); // phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound -- Template variable.
$altaudit82ai_template_service = altaudit82ai()->get_service( 'template_service' ); // phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound -- Template variable.
?>

<div class="wrap alt-audit-section alt-audit-settings">
	<div class="alt-audit-header">
		<h1><?php echo esc_html( get_admin_page_title() ); ?></h1>
		<p class="alt-audit-subtitle">
			<?php esc_html_e( 'Configure Alt Audit to work best for your website', 'alt-audit' ); ?>
		</p>
	</div>

	<nav class="settings-nav">
		<a href="<?php echo esc_url( admin_url( 'admin.php?page=alt-audit-settings&tab=general' ) ); ?>"
			class="nav-button <?php echo esc_attr( 'general' === $active_tab ? 'active' : '' ); ?>">
			<span class="dashicons dashicons-admin-settings"></span>
			<?php esc_html_e( 'General', 'alt-audit' ); ?>
		</a>
		<a href="<?php echo esc_url( admin_url( 'admin.php?page=alt-audit-settings&tab=advanced' ) ); ?>"
			class="nav-button <?php echo esc_attr( 'advanced' === $active_tab ? 'active' : '' ); ?>">
			<span class="dashicons dashicons-admin-tools"></span>
			<?php esc_html_e( 'Advanced', 'alt-audit' ); ?>
		</a>
		<a href="<?php echo esc_url( admin_url( 'admin.php?page=alt-audit-settings&tab=templates' ) ); ?>"
			class="nav-button <?php echo esc_attr( 'templates' === $active_tab ? 'active' : '' ); ?>">
			<span class="dashicons dashicons-text-page"></span>
			<?php esc_html_e( 'Alt Text Builder', 'alt-audit' ); ?>
		</a>
		<a href="<?php echo esc_url( admin_url( 'admin.php?page=alt-audit-settings&tab=quality' ) ); ?>"
			class="nav-button <?php echo esc_attr( 'quality' === $active_tab ? 'active' : '' ); ?>">
			<span class="dashicons dashicons-star-filled"></span>
			<?php esc_html_e( 'Quality Settings', 'alt-audit' ); ?>
		</a>
	</nav>

	<form method="post" action="<?php echo esc_url( admin_url( 'admin-post.php' ) ); ?>" class="alt-audit-form">
		<?php wp_nonce_field( 'altaudit82ai_settings' ); ?>
		<input type="hidden" name="action" value="altaudit82ai_save_settings">
		<input type="hidden" name="tab" value="<?php echo esc_attr( $active_tab ); ?>">

		<div class="settings-content">
			<?php if ( 'general' === $active_tab ) : ?>
				<div class="settings-section api-configuration">
					<div class="section-header">
						<h2 class="section-title">
							<span class="dashicons dashicons-admin-network"></span>
							<?php esc_html_e( 'API Configuration', 'alt-audit' ); ?>
						</h2>
						<p class="section-description">
							<?php esc_html_e( 'Connect to Alt Audit AI services to enable alt text generation.', 'alt-audit' ); ?>
						</p>
					</div>

					<table class="form-table" role="presentation">
						<tbody>
							<tr>
								<th scope="row">
									<label for="api_key">
										<?php esc_html_e( 'API Key', 'alt-audit' ); ?>
										<span class="required">*</span>
									</label>
								</th>
								<td>
									<div class="form-field-wrapper">
										<div class="input-group alt-audit-api-key">
											<input type="password" id="api_key" name="api_key"
												value="<?php echo esc_attr( $altaudit82ai_settings->get( 'api_key' ) ); ?>"
												class="regular-text"
												placeholder="<?php esc_attr_e( 'Enter your API key', 'alt-audit' ); ?>" />
										</div>
										<p class="field-help">
											<?php
											$altaudit82ai_api_url = add_query_arg(
												array(
													'utm_source'   => 'plugin',
													'utm_medium'   => 'settings',
													'utm_campaign' => 'api_key',
												),
												'https://altaudit.com/api-tokens'
											);

											printf(
												/* translators: %s: altaudit.com link */
												esc_html__( 'Get your free API key from %s', 'alt-audit' ),
												'<a href="' . esc_url( $altaudit82ai_api_url ) . '" target="_blank" rel="noopener noreferrer">' .
												esc_html__( 'altaudit.com', 'alt-audit' ) .
												' <span class="dashicons dashicons-external"></span></a>'
											);
											?>
										</p>
									</div>
								</td>
							</tr>
						</tbody>
					</table>

					<div class="api-status">
						<div class="status-info">
							<div
								class="status-icon <?php echo esc_attr( $altaudit82ai_settings->is_api_configured() ? 'connected' : 'disconnected' ); ?>">
								<span
									class="dashicons <?php echo esc_attr( $altaudit82ai_settings->is_api_configured() ? 'dashicons-yes' : 'dashicons-warning' ); ?>"></span>
							</div>
							<div class="status-text">
								<p class="status-label">
									<?php echo $altaudit82ai_settings->is_api_configured() ? esc_html__( 'API Connected', 'alt-audit' ) : esc_html__( 'API Not Connected', 'alt-audit' ); ?>
								</p>
								<p class="status-description">
									<?php echo $altaudit82ai_settings->is_api_configured() ? esc_html__( 'Your API connection is active and ready to use.', 'alt-audit' ) : esc_html__( 'Configure your API key to enable AI-powered features.', 'alt-audit' ); ?>
								</p>
							</div>
						</div>
					<button type="button" class="button button-secondary test-connection"
						data-nonce="<?php echo esc_attr( wp_create_nonce( 'altaudit82ai_test_api' ) ); ?>"
						data-admin-url="<?php echo esc_url( admin_url( 'admin-post.php' ) ); ?>">
						<span class="dashicons dashicons-admin-network"></span>
						<?php esc_html_e( 'Test Connection', 'alt-audit' ); ?>
					</button>
				</div>
				</div>

				<div class="settings-section">
					<div class="section-header">
						<h2 class="section-title">
							<span class="dashicons dashicons-admin-generic"></span>
							<?php esc_html_e( 'Generation Settings', 'alt-audit' ); ?>
						</h2>
						<p class="section-description">
							<?php esc_html_e( 'Control how alt text is generated for your images.', 'alt-audit' ); ?>
						</p>
					</div>

					<table class="form-table" role="presentation">
						<tbody>
							<tr>
								<th scope="row">
									<label for="quality_threshold">
										<?php esc_html_e( 'Quality Threshold', 'alt-audit' ); ?>
									</label>
								</th>
								<td>
									<div class="form-field-wrapper">
										<div class="input-group">
											<div class="input-with-unit">
												<input type="number" id="quality_threshold" name="quality_threshold"
													value="<?php echo esc_attr( $altaudit82ai_settings->get( 'quality_threshold', 70 ) ); ?>"
													min="0" max="100" class="small-text" />
												<span class="input-unit">%</span>
											</div>
										</div>
										<p class="field-help">
											<?php esc_html_e( 'Minimum quality score for alt text to be considered acceptable', 'alt-audit' ); ?>
										</p>
									</div>
								</td>
							</tr>

							<tr>
								<th scope="row">
									<label for="max_length">
										<?php esc_html_e( 'Maximum Length', 'alt-audit' ); ?>
									</label>
								</th>
								<td>
									<div class="form-field-wrapper">
										<div class="input-group">
											<div class="input-with-unit">
												<input type="number" id="max_length" name="max_length"
													value="<?php echo esc_attr( $altaudit82ai_settings->get( 'max_length', 125 ) ); ?>"
													min="50" max="300" class="small-text" />
												<span class="input-unit"><?php esc_html_e( 'chars', 'alt-audit' ); ?></span>
											</div>
										</div>
										<p class="field-help">
											<?php esc_html_e( 'Maximum character length for generated alt text', 'alt-audit' ); ?>
										</p>
									</div>
								</td>
							</tr>

							<tr>
								<th scope="row">
									<label for="style">
										<?php esc_html_e( 'Alt Text Style', 'alt-audit' ); ?>
									</label>
								</th>
								<td>
									<div class="form-field-wrapper">
										<select id="style" name="style" class="regular-text">
											<?php foreach ( $altaudit82ai_settings->get_style_options() as $altaudit82ai_value => $altaudit82ai_label ) : // phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound -- Template loop variables. ?>
												<option value="<?php echo esc_attr( $altaudit82ai_value ); ?>" <?php selected( $altaudit82ai_settings->get( 'style' ), $altaudit82ai_value ); ?>>
													<?php echo esc_html( $altaudit82ai_label ); ?>
												</option>
											<?php endforeach; ?>
										</select>
										<p class="field-help">
											<?php esc_html_e( 'Choose the style of alt text generation that best fits your content', 'alt-audit' ); ?>
										</p>
									</div>
								</td>
							</tr>
						</tbody>
					</table>
				</div>

			<?php elseif ( 'advanced' === $active_tab ) : ?>
				<div class="settings-section">
					<div class="section-header">
						<h2 class="section-title">
							<span class="dashicons dashicons-admin-tools"></span>
							<?php esc_html_e( 'Advanced Features', 'alt-audit' ); ?>
						</h2>
						<p class="section-description">
							<?php esc_html_e( 'Fine-tune Alt Audit behavior for optimal performance.', 'alt-audit' ); ?>
						</p>
					</div>

					<table class="form-table" role="presentation">
						<tbody>
							<tr>
								<th scope="row"><?php esc_html_e( 'Features', 'alt-audit' ); ?></th>
								<td>
									<div class="form-field-wrapper">
										<div class="checkbox-wrapper">
											<input type="checkbox" id="context_aware" name="context_aware" value="1" <?php checked( $altaudit82ai_settings->get( 'context_aware' ) ); ?> />
											<div class="checkbox-content">
												<span
													class="checkbox-label"><?php esc_html_e( 'Context Aware Generation', 'alt-audit' ); ?></span>
												<p class="checkbox-description">
													<?php esc_html_e( 'Use surrounding content to improve alt text generation', 'alt-audit' ); ?>
												</p>
											</div>
										</div>
									</div>

									<div class="form-field-wrapper">
										<div class="checkbox-wrapper">
											<input type="checkbox" id="debug_mode" name="debug_mode" value="1" <?php checked( $altaudit82ai_settings->get( 'debug_mode' ) ); ?> />
											<div class="checkbox-content">
												<span
													class="checkbox-label"><?php esc_html_e( 'Debug Mode', 'alt-audit' ); ?></span>
												<p class="checkbox-description">
													<?php esc_html_e( 'Enable debug logging for troubleshooting', 'alt-audit' ); ?>
												</p>
											</div>
										</div>
									</div>
								</td>
							</tr>
						</tbody>
					</table>
				</div>



			<?php elseif ( 'templates' === $active_tab ) : ?>
				<?php
				// Get saved values for each post type.
				// phpcs:disable WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound -- Template variables.
				$altaudit82ai_home_images_alt    = $altaudit82ai_settings->get( 'home_images_alt', array( 'Site Name', '|', 'Page Title' ) );
				$altaudit82ai_pages_images_alt   = $altaudit82ai_settings->get( 'pages_images_alt', array( 'Site Name', '|', 'Page Title', 'Site Description' ) );
				$altaudit82ai_post_images_alt    = $altaudit82ai_settings->get( 'post_images_alt', array( 'Site Name', '|', 'Post Title' ) );
				$altaudit82ai_product_images_alt = $altaudit82ai_settings->get( 'product_images_alt', array( 'Site Name', '|', 'Product Title' ) );
				$altaudit82ai_cpt_images_alt     = $altaudit82ai_settings->get( 'cpt_images_alt', array( 'Site Name', '|', 'Post Title' ) );

				// Available options for dropdowns.
				$altaudit82ai_common_options = array( 'Site Name', 'Site Description', 'Image Alt', 'Image Name', 'Image Caption', 'Image Description', '&', '|', '-', '_' );
				// phpcs:enable WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound
				?>

				<div class="settings-section alt-text-templates">
					<div class="section-header">
						<h2 class="section-title">
							<span class="dashicons dashicons-text-page"></span>
							<?php esc_html_e( 'Custom Alt Text Builder', 'alt-audit' ); ?>
						</h2>
						<p class="section-description">
							<?php esc_html_e( 'Design your alt text patterns. Click variables below to add them to your pattern.', 'alt-audit' ); ?>
						</p>
					</div>

					<?php
					// Helper function to render a builder section (defined conditionally to avoid redeclaration).
					if ( ! function_exists( 'altaudit82ai_render_builder_section' ) ) {
						/**
						 * Render a builder section for the Alt Text Builder.
						 *
						 * @param string $title         Section title.
						 * @param string $description   Section description.
						 * @param string $field_name    Field name for form.
						 * @param array  $current_value Current field value.
						 * @param array  $options       Available options.
						 * @return void
						 */
						function altaudit82ai_render_builder_section( $title, $description, $field_name, $current_value, $options ) {
							?>
							<div class="alt-builder-section">
								<div class="alt-builder-header">
									<h3><?php echo esc_html( $title ); ?></h3>
									<p><?php echo esc_html( $description ); ?></p>
								</div>

								<!-- Visual Editor -->
								<div class="pattern-editor" id="editor-<?php echo esc_attr( $field_name ); ?>">
									<span
										class="builder-empty-state"><?php esc_html_e( 'Click tokens below to build your pattern...', 'alt-audit' ); ?></span>
								</div>

								<!-- Available Tokens -->
								<div class="available-tokens">
									<?php foreach ( $options as $option ) : ?>
										<button type="button"
											class="token-btn <?php echo esc_attr( in_array( $option, array( '&', '|', '-', '_' ), true ) ? 'separator' : '' ); ?>"
											data-value="<?php echo esc_attr( $option ); ?>">
											<?php if ( ! in_array( $option, array( '&', '|', '-', '_' ), true ) ) : ?>
												<span class="dashicons dashicons-plus"
													style="font-size: 14px; width: 14px; height: 14px; margin-right: 4px;"></span>
											<?php endif; ?>
											<?php echo esc_html( $option ); ?>
										</button>
									<?php endforeach; ?>
								</div>

								<!-- Hidden Select for Form Submission -->
								<select name="<?php echo esc_attr( $field_name ); ?>[]"
									id="input-<?php echo esc_attr( $field_name ); ?>" multiple style="display:none;">
									<?php foreach ( $current_value as $val ) : ?>
										<option value="<?php echo esc_attr( $val ); ?>" selected><?php echo esc_html( $val ); ?>
										</option>
									<?php endforeach; ?>
								</select>
							</div>
							<?php
						}
					}

					// Render Sections.
					altaudit82ai_render_builder_section(
						__( 'Homepage Images', 'alt-audit' ),
						__( 'Pattern for images on the homepage.', 'alt-audit' ),
						'home_images_alt',
						$altaudit82ai_home_images_alt,
						array_merge( array( 'Page Title' ), $altaudit82ai_common_options )
					);

					altaudit82ai_render_builder_section(
						__( 'Pages Images', 'alt-audit' ),
						__( 'Pattern for images on standard pages.', 'alt-audit' ),
						'pages_images_alt',
						$altaudit82ai_pages_images_alt,
						array_merge( array( 'Page Title' ), $altaudit82ai_common_options )
					);

					altaudit82ai_render_builder_section(
						__( 'Posts Images', 'alt-audit' ),
						__( 'Pattern for images on blog posts.', 'alt-audit' ),
						'post_images_alt',
						$altaudit82ai_post_images_alt,
						array_merge( array( 'Post Title' ), $altaudit82ai_common_options )
					);

					altaudit82ai_render_builder_section(
						__( 'Products Images', 'alt-audit' ),
						__( 'Pattern for images on product pages.', 'alt-audit' ),
						'product_images_alt',
						$altaudit82ai_product_images_alt,
						array_merge( array( 'Product Title' ), $altaudit82ai_common_options )
					);

					altaudit82ai_render_builder_section(
						__( 'Custom Post Type Images', 'alt-audit' ),
						__( 'Pattern for images on other post types.', 'alt-audit' ),
						'cpt_images_alt',
						$altaudit82ai_cpt_images_alt,
						array_merge( array( 'Post Title' ), $altaudit82ai_common_options )
					);
				?>
				</div>

			<?php elseif ( 'quality' === $active_tab ) : ?>
				<div class="settings-section quality-thresholds">
					<div class="section-header">
						<h2 class="section-title">
							<span class="dashicons dashicons-star-filled"></span>
							<?php esc_html_e( 'Quality Assessment System', 'alt-audit' ); ?>
						</h2>
						<p class="section-description">
							<?php esc_html_e( 'Understanding how Alt Audit evaluates and scores alt text quality.', 'alt-audit' ); ?>
						</p>
					</div>

					<div class="threshold-grid">
						<div class="threshold-card missing">
							<div class="threshold-icon">
								<span class="dashicons dashicons-warning"></span>
							</div>
							<p class="threshold-label"><?php esc_html_e( 'Missing', 'alt-audit' ); ?></p>
							<p class="threshold-range">0-20</p>
							<p class="field-help">
								<?php esc_html_e( 'No alt text present - significant accessibility barrier', 'alt-audit' ); ?>
							</p>
						</div>

						<?php
						/*
						Decorative threshold removed - simplified status system
						<div class="threshold-card decorative">
							<div class="threshold-icon">
								<span class="dashicons dashicons-minus"></span>
							</div>
							<p class="threshold-label"><?php esc_html_e( 'Decorative', 'alt-audit' ); ?></p>
							<p class="threshold-range">21-40</p>
							<p class="field-help"><?php esc_html_e( 'Empty alt for decorative images - appropriate when correct', 'alt-audit' ); ?></p>
						</div>
						*/
						?>

						<div class="threshold-card weak">
							<div class="threshold-icon">
								<span class="dashicons dashicons-flag"></span>
							</div>
							<p class="threshold-label"><?php esc_html_e( 'Weak', 'alt-audit' ); ?></p>
							<p class="threshold-range">41-60</p>
							<p class="field-help">
								<?php esc_html_e( 'Present but lacks detail - needs improvement', 'alt-audit' ); ?>
							</p>
						</div>

						<div class="threshold-card good">
							<div class="threshold-icon">
								<span class="dashicons dashicons-thumbs-up"></span>
							</div>
							<p class="threshold-label"><?php esc_html_e( 'Good', 'alt-audit' ); ?></p>
							<p class="threshold-range">61-85</p>
							<p class="field-help">
								<?php esc_html_e( 'Meets basic accessibility standards - clear and functional', 'alt-audit' ); ?>
							</p>
						</div>

						<div class="threshold-card excellent">
							<div class="threshold-icon">
								<span class="dashicons dashicons-awards"></span>
							</div>
							<p class="threshold-label"><?php esc_html_e( 'Excellent', 'alt-audit' ); ?></p>
							<p class="threshold-range">86-100</p>
							<p class="field-help">
								<?php esc_html_e( 'Exceptional quality - gold standard accessibility', 'alt-audit' ); ?>
							</p>
						</div>
					</div>
				</div>

				<div class="settings-section wcag-compliance">
					<div class="section-header">
						<h2 class="section-title">
							<span class="dashicons dashicons-shield"></span>
							<?php esc_html_e( 'WCAG 1.1.1 Image Compliance', 'alt-audit' ); ?>
						</h2>
						<p class="section-description">
							<?php esc_html_e( 'Alt Audit focuses on WCAG 2.1 Success Criterion 1.1.1 (Non-text Content) - the foundational requirement for image accessibility.', 'alt-audit' ); ?>
						</p>
					</div>

					<div class="compliance-levels">
						<div class="compliance-level">
							<div class="level-badge level-a">1.1.1</div>
							<h4><?php esc_html_e( 'Non-text Content (Level A)', 'alt-audit' ); ?></h4>
							<p class="level-description">
								<?php esc_html_e( 'All non-decorative images must have text alternatives that serve the equivalent purpose.', 'alt-audit' ); ?>
							</p>
						</div>

						<div class="compliance-level">
							<div class="level-badge level-check">✓</div>
							<h4><?php esc_html_e( 'What We Check', 'alt-audit' ); ?></h4>
							<p class="level-description">
								<?php esc_html_e( 'Missing alt text, decorative image handling, filename repetition, and alt text quality.', 'alt-audit' ); ?>
							</p>
						</div>

						<div class="compliance-level">
							<div class="level-badge level-quality">★</div>
							<h4><?php esc_html_e( 'Quality Standards', 'alt-audit' ); ?></h4>
							<p class="level-description">
								<?php esc_html_e( 'Beyond compliance: concise length (under 125 chars), meaningful descriptions, and contextual relevance.', 'alt-audit' ); ?>
							</p>
						</div>
					</div>
				</div>
			<?php endif; ?>
		</div>

		<div class="form-actions">
			<div class="actions-left">
				<?php submit_button( esc_html__( 'Save Settings', 'alt-audit' ), 'primary button-primary', 'submit', false ); ?>
			</div>
			<div class="actions-right">
				<p class="field-help">
					<?php esc_html_e( 'Changes will take effect immediately after saving.', 'alt-audit' ); ?>
				</p>
			</div>
		</div>

		<div class="alt-text-builder-help"
			style="background: #f0f6fc; border-left: 4px solid #2271b1; padding: 15px 20px; margin: 20px 0;">
			<h3 style="margin-top: 0;"><?php esc_html_e( 'How the Alt Text Builder Works', 'alt-audit' ); ?></h3>
			<p><?php esc_html_e( 'The Alt Text Builder creates structured, consistent alt text across your entire website by combining dynamic variables in customizable patterns.', 'alt-audit' ); ?>
			</p>

			<h4><?php esc_html_e( 'Available Variables:', 'alt-audit' ); ?></h4>
			<ul style="list-style: disc; margin-left: 20px;">
				<li><strong><?php esc_html_e( 'Site Name:', 'alt-audit' ); ?></strong>
					<?php esc_html_e( 'Your website name for consistent branding', 'alt-audit' ); ?></li>
				<li><strong><?php esc_html_e( 'Site Description:', 'alt-audit' ); ?></strong>
					<?php esc_html_e( 'Your website tagline or description', 'alt-audit' ); ?></li>
				<li><strong><?php esc_html_e( 'Page/Post/Product Title:', 'alt-audit' ); ?></strong>
					<?php esc_html_e( 'The title of the page, post, or product where the image appears', 'alt-audit' ); ?>
				</li>
				<li><strong><?php esc_html_e( 'Image Name:', 'alt-audit' ); ?></strong>
					<?php esc_html_e( 'The filename of the image (automatically cleaned)', 'alt-audit' ); ?></li>
				<li><strong><?php esc_html_e( 'Image Caption:', 'alt-audit' ); ?></strong>
					<?php esc_html_e( 'The caption text from the media library', 'alt-audit' ); ?></li>
				<li><strong><?php esc_html_e( 'Image Description:', 'alt-audit' ); ?></strong>
					<?php esc_html_e( 'The description text from the media library', 'alt-audit' ); ?></li>
				<li><strong><?php esc_html_e( 'Image Alt:', 'alt-audit' ); ?></strong>
					<?php esc_html_e( 'The existing alt text (if any)', 'alt-audit' ); ?></li>
				<li><strong><?php esc_html_e( 'Separators (|, -, _, &):', 'alt-audit' ); ?></strong>
					<?php esc_html_e( 'Visual separators to organize your alt text', 'alt-audit' ); ?></li>
			</ul>

			<h4><?php esc_html_e( 'Example Patterns:', 'alt-audit' ); ?></h4>
			<p><code><?php esc_html_e( 'Site Name | Page Title', 'alt-audit' ); ?></code> →
				<?php esc_html_e( '"My Company | About Us"', 'alt-audit' ); ?>
			</p>
			<p><code><?php esc_html_e( 'Post Title - Image Name', 'alt-audit' ); ?></code> →
				<?php esc_html_e( '"10 Tips for SEO - featured-image"', 'alt-audit' ); ?>
			</p>
			<p><code><?php esc_html_e( 'Site Name | Product Title & Image Name', 'alt-audit' ); ?></code> →
				<?php esc_html_e( '"My Store | Red T-Shirt & product-photo"', 'alt-audit' ); ?>
			</p>

			<h4><?php esc_html_e( 'Benefits:', 'alt-audit' ); ?></h4>
			<ul style="list-style: disc; margin-left: 20px;">
				<li><?php esc_html_e( 'Completely FREE - no credits required', 'alt-audit' ); ?></li>
				<li><?php esc_html_e( 'Consistent alt text structure across your website', 'alt-audit' ); ?></li>
				<li><?php esc_html_e( 'SEO-friendly with relevant context and keywords', 'alt-audit' ); ?></li>
				<li><?php esc_html_e( 'Different patterns for different content types (homepage, pages, posts, products)', 'alt-audit' ); ?>
				</li>
				<li><?php esc_html_e( 'Fully customizable - arrange variables in any order', 'alt-audit' ); ?></li>
				<li><?php esc_html_e( 'Automatic application options (new uploads, weak quality replacement)', 'alt-audit' ); ?>
				</li>
			</ul>
		</div>
	</form>
</div>