<?php
/**
 * Admin Help & Support Template
 *
 * @package AltAudit
 * @since 1.0.0
 */

// Prevent direct access.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
?>

<div class="wrap alt-audit-section alt-audit-help">
	<div class="alt-audit-header">
		<h1><?php echo esc_html( get_admin_page_title() ); ?></h1>
		<p class="alt-audit-subtitle"><?php esc_html_e( 'Comprehensive guide to using Alt Audit for improving website accessibility', 'alt-audit' ); ?></p>
	</div>

	<div class="alt-audit-help-container">
		<!-- Help Navigation -->
		<nav class="help-nav" role="navigation" aria-label="<?php esc_attr_e( 'Help sections navigation', 'alt-audit' ); ?>">
			<button type="button" class="nav-link active" data-section="getting-started" role="tab" aria-selected="true" aria-controls="getting-started">
				<span class="nav-icon">
					<span class="dashicons dashicons-welcome-learn-more" aria-hidden="true"></span>
				</span>
				<span class="nav-text"><?php esc_html_e( 'Getting Started', 'alt-audit' ); ?></span>
			</button>
			<button type="button" class="nav-link" data-section="features" role="tab" aria-selected="false" aria-controls="features">
				<span class="nav-icon">
					<span class="dashicons dashicons-admin-tools" aria-hidden="true"></span>
				</span>
				<span class="nav-text"><?php esc_html_e( 'Features', 'alt-audit' ); ?></span>
			</button>
			<button type="button" class="nav-link" data-section="quality-system" role="tab" aria-selected="false" aria-controls="quality-system">
				<span class="nav-icon">
					<span class="dashicons dashicons-analytics" aria-hidden="true"></span>
				</span>
				<span class="nav-text"><?php esc_html_e( 'Quality System', 'alt-audit' ); ?></span>
			</button>
			<button type="button" class="nav-link" data-section="troubleshooting" role="tab" aria-selected="false" aria-controls="troubleshooting">
				<span class="nav-icon">
					<span class="dashicons dashicons-sos" aria-hidden="true"></span>
				</span>
				<span class="nav-text"><?php esc_html_e( 'Troubleshooting', 'alt-audit' ); ?></span>
			</button>
			<button type="button" class="nav-link" data-section="support" role="tab" aria-selected="false" aria-controls="support">
				<span class="nav-icon">
					<span class="dashicons dashicons-groups" aria-hidden="true"></span>
				</span>
				<span class="nav-text"><?php esc_html_e( 'Support', 'alt-audit' ); ?></span>
			</button>
		</nav>

		<!-- Help Content -->
		<div class="help-content" role="tabpanel">
			<!-- Getting Started -->
			<section id="getting-started" class="help-section active" role="tabpanel" aria-labelledby="getting-started-tab">
				<div class="section-header">
					<h2 class="section-title">
						<span class="dashicons dashicons-welcome-learn-more" aria-hidden="true"></span>
						<?php esc_html_e( 'Getting Started with Alt Audit', 'alt-audit' ); ?>
					</h2>
					<p class="section-description"><?php esc_html_e( 'Follow these simple steps to start improving your website\'s accessibility with AI-powered alt text generation.', 'alt-audit' ); ?></p>
				</div>

				<div class="help-steps">
					<div class="help-step" style="--step-index: 0;">
						<div class="step-indicator">
							<span class="step-number">1</span>
						</div>
						<div class="step-content">
							<h3 class="step-title"><?php esc_html_e( 'Configure API Settings', 'alt-audit' ); ?></h3>
							<p class="step-description"><?php esc_html_e( 'Connect to the Alt Audit service by entering your API key. This enables AI-powered alt text generation and quality analysis features.', 'alt-audit' ); ?></p>
							<div class="step-features">
								<div class="feature-item">
									<span class="dashicons dashicons-yes-alt" aria-hidden="true"></span>
									<span><?php esc_html_e( 'Secure API authentication', 'alt-audit' ); ?></span>
								</div>
								<div class="feature-item">
									<span class="dashicons dashicons-yes-alt" aria-hidden="true"></span>
									<span><?php esc_html_e( 'Automatic connection testing', 'alt-audit' ); ?></span>
								</div>
							</div>
							<div class="step-action">
								<a href="<?php echo esc_url( admin_url( 'admin.php?page=alt-audit-settings' ) ); ?>" class="button button-primary">
									<span class="dashicons dashicons-admin-generic" aria-hidden="true"></span>
									<?php esc_html_e( 'Configure Settings', 'alt-audit' ); ?>
								</a>
							</div>
						</div>
					</div>

					<div class="help-step" style="--step-index: 1;">
						<div class="step-indicator">
							<span class="step-number">2</span>
						</div>
						<div class="step-content">
							<h3 class="step-title"><?php esc_html_e( 'Run Your First Site Audit', 'alt-audit' ); ?></h3>
							<p class="step-description"><?php esc_html_e( 'Discover accessibility issues across your entire website with a comprehensive image audit that identifies missing and low-quality alt text.', 'alt-audit' ); ?></p>
							<div class="step-features">
								<div class="feature-item">
									<span class="dashicons dashicons-yes-alt" aria-hidden="true"></span>
									<span><?php esc_html_e( 'Site-wide image analysis', 'alt-audit' ); ?></span>
								</div>
								<div class="feature-item">
									<span class="dashicons dashicons-yes-alt" aria-hidden="true"></span>
									<span><?php esc_html_e( 'WCAG compliance scoring', 'alt-audit' ); ?></span>
								</div>
							</div>
							<div class="step-action">
								<a href="<?php echo esc_url( admin_url( 'admin.php?page=alt-audit-audit' ) ); ?>" class="button button-secondary">
									<span class="dashicons dashicons-search" aria-hidden="true"></span>
									<?php esc_html_e( 'Start Site Audit', 'alt-audit' ); ?>
								</a>
							</div>
						</div>
					</div>

					<div class="help-step" style="--step-index: 2;">
						<div class="step-indicator">
							<span class="step-number">3</span>
						</div>
						<div class="step-content">
							<h3 class="step-title"><?php esc_html_e( 'Generate Quality Alt Text', 'alt-audit' ); ?></h3>
							<p class="step-description"><?php esc_html_e( 'Use advanced AI algorithms to automatically generate contextual, accessible alt text that meets WCAG guidelines and improves user experience.', 'alt-audit' ); ?></p>
							<div class="step-features">
								<div class="feature-item">
									<span class="dashicons dashicons-yes-alt" aria-hidden="true"></span>
									<span><?php esc_html_e( 'Batch processing capabilities', 'alt-audit' ); ?></span>
								</div>
								<div class="feature-item">
									<span class="dashicons dashicons-yes-alt" aria-hidden="true"></span>
									<span><?php esc_html_e( 'Context-aware descriptions', 'alt-audit' ); ?></span>
								</div>
							</div>
							<div class="step-action">
								<a href="<?php echo esc_url( admin_url( 'admin.php?page=alt-audit-bulk' ) ); ?>" class="button button-secondary">
									<span class="dashicons dashicons-admin-tools" aria-hidden="true"></span>
									<?php esc_html_e( 'Open Bulk Tools', 'alt-audit' ); ?>
								</a>
							</div>
						</div>
					</div>
				</div>

				<div class="quick-tips">
					<h3 class="tips-title"><?php esc_html_e( 'Quick Tips for Success', 'alt-audit' ); ?></h3>
					<div class="tips-grid">
						<div class="tip-card">
							<div class="tip-icon">
								<span class="dashicons dashicons-lightbulb" aria-hidden="true"></span>
							</div>
							<h4><?php esc_html_e( 'Start Small', 'alt-audit' ); ?></h4>
							<p><?php esc_html_e( 'Begin with a single page or post type to familiarize yourself with the process.', 'alt-audit' ); ?></p>
						</div>
						<div class="tip-card">
							<div class="tip-icon">
								<span class="dashicons dashicons-performance" aria-hidden="true"></span>
							</div>
							<h4><?php esc_html_e( 'Review Results', 'alt-audit' ); ?></h4>
							<p><?php esc_html_e( 'Always review AI-generated alt text to ensure it matches your content context.', 'alt-audit' ); ?></p>
						</div>
						<div class="tip-card">
							<div class="tip-icon">
								<span class="dashicons dashicons-backup" aria-hidden="true"></span>
							</div>
							<h4><?php esc_html_e( 'Backup First', 'alt-audit' ); ?></h4>
							<p><?php esc_html_e( 'Enable automatic backups before running bulk operations for peace of mind.', 'alt-audit' ); ?></p>
						</div>
					</div>
				</div>
			</section>

			<!-- Features -->
			<section id="features" class="help-section" role="tabpanel" aria-labelledby="features-tab">
				<div class="section-header">
					<h2 class="section-title">
						<span class="dashicons dashicons-admin-tools" aria-hidden="true"></span>
						<?php esc_html_e( 'Alt Audit Features', 'alt-audit' ); ?>
					</h2>
					<p class="section-description"><?php esc_html_e( 'Explore the comprehensive suite of tools designed to make your website fully accessible.', 'alt-audit' ); ?></p>
				</div>

				<div class="features-grid">
					<div class="feature-card ai-feature" style="--card-index: 0;">
						<div class="feature-header">
							<div class="feature-icon">
								<span class="dashicons dashicons-admin-generic" aria-hidden="true"></span>
							</div>
							<h3><?php esc_html_e( 'AI-Powered Generation', 'alt-audit' ); ?></h3>
						</div>
						<div class="feature-content">
							<p><?php esc_html_e( 'Advanced computer vision AI analyzes images and generates contextually appropriate, accessible alt text that meets WCAG standards.', 'alt-audit' ); ?></p>
							<div class="feature-benefits">
								<div class="benefit-item">
									<span class="dashicons dashicons-yes-alt" aria-hidden="true"></span>
									<span><?php esc_html_e( 'Context-aware descriptions', 'alt-audit' ); ?></span>
								</div>
								<div class="benefit-item">
									<span class="dashicons dashicons-yes-alt" aria-hidden="true"></span>
									<span><?php esc_html_e( 'SEO-friendly descriptions', 'alt-audit' ); ?></span>
								</div>
								<div class="benefit-item">
									<span class="dashicons dashicons-yes-alt" aria-hidden="true"></span>
									<span><?php esc_html_e( 'Emotional tone detection', 'alt-audit' ); ?></span>
								</div>
							</div>
						</div>
					</div>

					<div class="feature-card quality-feature" style="--card-index: 1;">
						<div class="feature-header">
							<div class="feature-icon">
								<span class="dashicons dashicons-analytics" aria-hidden="true"></span>
							</div>
							<h3><?php esc_html_e( 'Quality Assessment', 'alt-audit' ); ?></h3>
						</div>
						<div class="feature-content">
							<p><?php esc_html_e( 'Comprehensive 5-level quality system evaluates alt text from Missing to Excellent using machine learning algorithms.', 'alt-audit' ); ?></p>
							<div class="feature-benefits">
								<div class="benefit-item">
									<span class="dashicons dashicons-yes-alt" aria-hidden="true"></span>
									<span><?php esc_html_e( 'Real-time quality scoring', 'alt-audit' ); ?></span>
								</div>
								<div class="benefit-item">
									<span class="dashicons dashicons-yes-alt" aria-hidden="true"></span>
									<span><?php esc_html_e( 'Improvement suggestions', 'alt-audit' ); ?></span>
								</div>
								<div class="benefit-item">
									<span class="dashicons dashicons-yes-alt" aria-hidden="true"></span>
									<span><?php esc_html_e( 'Progress tracking', 'alt-audit' ); ?></span>
								</div>
							</div>
						</div>
					</div>

					<div class="feature-card compliance-feature" style="--card-index: 2;">
						<div class="feature-header">
							<div class="feature-icon">
								<span class="dashicons dashicons-awards" aria-hidden="true"></span>
							</div>
							<h3><?php esc_html_e( 'Image Accessibility', 'alt-audit' ); ?></h3>
						</div>
						<div class="feature-content">
							<p><?php esc_html_e( 'Check your images against WCAG 1.1.1 (Non-text Content) guidelines for better accessibility.', 'alt-audit' ); ?></p>
							<div class="feature-benefits">
								<div class="benefit-item">
									<span class="dashicons dashicons-yes-alt" aria-hidden="true"></span>
									<span><?php esc_html_e( 'WCAG 1.1.1 checking', 'alt-audit' ); ?></span>
								</div>
								<div class="benefit-item">
									<span class="dashicons dashicons-yes-alt" aria-hidden="true"></span>
									<span><?php esc_html_e( 'Alt text quality analysis', 'alt-audit' ); ?></span>
								</div>
								<div class="benefit-item">
									<span class="dashicons dashicons-yes-alt" aria-hidden="true"></span>
									<span><?php esc_html_e( 'Image audit reports', 'alt-audit' ); ?></span>
								</div>
							</div>
						</div>
					</div>

					<div class="feature-card bulk-feature" style="--card-index: 3;">
						<div class="feature-header">
							<div class="feature-icon">
								<span class="dashicons dashicons-update" aria-hidden="true"></span>
							</div>
							<h3><?php esc_html_e( 'Bulk Operations', 'alt-audit' ); ?></h3>
						</div>
						<div class="feature-content">
							<p><?php esc_html_e( 'Process hundreds or thousands of images at once with intelligent batch operations and progress tracking.', 'alt-audit' ); ?></p>
							<div class="feature-benefits">
								<div class="benefit-item">
									<span class="dashicons dashicons-yes-alt" aria-hidden="true"></span>
									<span><?php esc_html_e( 'Batch processing up to 1000 images', 'alt-audit' ); ?></span>
								</div>
								<div class="benefit-item">
									<span class="dashicons dashicons-yes-alt" aria-hidden="true"></span>
									<span><?php esc_html_e( 'Real-time progress monitoring', 'alt-audit' ); ?></span>
								</div>
								<div class="benefit-item">
									<span class="dashicons dashicons-yes-alt" aria-hidden="true"></span>
									<span><?php esc_html_e( 'Automatic error handling', 'alt-audit' ); ?></span>
								</div>
							</div>
						</div>
					</div>

					<div class="feature-card audit-feature" style="--card-index: 4;">
						<div class="feature-header">
							<div class="feature-icon">
								<span class="dashicons dashicons-search" aria-hidden="true"></span>
							</div>
							<h3><?php esc_html_e( 'Site Auditing', 'alt-audit' ); ?></h3>
						</div>
						<div class="feature-content">
							<p><?php esc_html_e( 'Comprehensive analysis of all images across your entire website with detailed accessibility reports and recommendations.', 'alt-audit' ); ?></p>
							<div class="feature-benefits">
								<div class="benefit-item">
									<span class="dashicons dashicons-yes-alt" aria-hidden="true"></span>
									<span><?php esc_html_e( 'Full site image discovery', 'alt-audit' ); ?></span>
								</div>
								<div class="benefit-item">
									<span class="dashicons dashicons-yes-alt" aria-hidden="true"></span>
									<span><?php esc_html_e( 'Detailed accessibility reports', 'alt-audit' ); ?></span>
								</div>
								<div class="benefit-item">
									<span class="dashicons dashicons-yes-alt" aria-hidden="true"></span>
									<span><?php esc_html_e( 'Priority-based recommendations', 'alt-audit' ); ?></span>
								</div>
							</div>
						</div>
					</div>

					<div class="feature-card export-feature" style="--card-index: 5;">
						<div class="feature-header">
							<div class="feature-icon">
								<span class="dashicons dashicons-download" aria-hidden="true"></span>
							</div>
							<h3><?php esc_html_e( 'Data Export', 'alt-audit' ); ?></h3>
						</div>
						<div class="feature-content">
							<p><?php esc_html_e( 'Export alt text data for backup purposes and external analysis with comprehensive reporting capabilities.', 'alt-audit' ); ?></p>
							<div class="feature-benefits">
								<div class="benefit-item">
									<span class="dashicons dashicons-yes-alt" aria-hidden="true"></span>
									<span><?php esc_html_e( 'CSV, JSON, XML export formats', 'alt-audit' ); ?></span>
								</div>
								<div class="benefit-item">
									<span class="dashicons dashicons-yes-alt" aria-hidden="true"></span>
									<span><?php esc_html_e( 'Complete data backup', 'alt-audit' ); ?></span>
								</div>
								<div class="benefit-item">
									<span class="dashicons dashicons-yes-alt" aria-hidden="true"></span>
									<span><?php esc_html_e( 'Quality score reports', 'alt-audit' ); ?></span>
								</div>
							</div>
						</div>
					</div>

					<div class="feature-card builder-feature" style="--card-index: 6;">
						<div class="feature-header">
							<div class="feature-icon">
								<span class="dashicons dashicons-text-page" aria-hidden="true"></span>
							</div>
							<h3><?php esc_html_e( 'Alt Text Builder (FREE)', 'alt-audit' ); ?></h3>
						</div>
						<div class="feature-content">
							<p><?php esc_html_e( 'Create structured, consistent alt text across your website by building custom patterns with dynamic variables. Completely FREE with no credits required - generate unlimited alt text using your own patterns.', 'alt-audit' ); ?></p>
							<div class="feature-benefits">
								<div class="benefit-item">
									<span class="dashicons dashicons-yes-alt" aria-hidden="true"></span>
									<span><?php esc_html_e( 'Completely FREE - no credits needed', 'alt-audit' ); ?></span>
								</div>
								<div class="benefit-item">
									<span class="dashicons dashicons-yes-alt" aria-hidden="true"></span>
									<span><?php esc_html_e( 'Custom patterns per post type', 'alt-audit' ); ?></span>
								</div>
								<div class="benefit-item">
									<span class="dashicons dashicons-yes-alt" aria-hidden="true"></span>
									<span><?php esc_html_e( 'Drag-and-drop variable builder', 'alt-audit' ); ?></span>
								</div>
								<div class="benefit-item">
									<span class="dashicons dashicons-yes-alt" aria-hidden="true"></span>
									<span><?php esc_html_e( 'SEO-friendly with context', 'alt-audit' ); ?></span>
								</div>
								<div class="benefit-item">
									<span class="dashicons dashicons-yes-alt" aria-hidden="true"></span>
									<span><?php esc_html_e( 'Auto-apply to new uploads', 'alt-audit' ); ?></span>
								</div>
								<div class="benefit-item">
									<span class="dashicons dashicons-yes-alt" aria-hidden="true"></span>
									<span><?php esc_html_e( 'Separate patterns for homepage, pages, posts, products', 'alt-audit' ); ?></span>
								</div>
							</div>
							<div class="feature-action">
								<a href="<?php echo esc_url( admin_url( 'admin.php?page=alt-audit-settings&tab=templates' ) ); ?>" class="button button-primary">
									<span class="dashicons dashicons-admin-generic" aria-hidden="true"></span>
									<?php esc_html_e( 'Configure Alt Text Builder', 'alt-audit' ); ?>
								</a>
							</div>
						</div>
					</div>
				</div>
			</section>

			<!-- Quality System -->
			<section id="quality-system" class="help-section" role="tabpanel" aria-labelledby="quality-system-tab">
				<div class="section-header">
					<h2 class="section-title">
						<span class="dashicons dashicons-analytics" aria-hidden="true"></span>
						<?php esc_html_e( 'Understanding the Quality System', 'alt-audit' ); ?>
					</h2>
					<p class="section-description"><?php esc_html_e( 'Our advanced 5-level quality system evaluates alt text using machine learning algorithms trained on WCAG guidelines and accessibility best practices.', 'alt-audit' ); ?></p>
				</div>

				<div class="quality-levels-container">
					<div class="quality-level quality-missing" style="--level-index: 0;">
						<div class="quality-badge">
							<div class="quality-score">0-20</div>
							<div class="quality-label"><?php esc_html_e( 'Missing', 'alt-audit' ); ?></div>
						</div>
						<div class="quality-content">
							<h3><?php esc_html_e( 'Missing Alt Text', 'alt-audit' ); ?></h3>
							<p><?php esc_html_e( 'No alt text present or completely empty alt attribute. This creates significant accessibility barriers for users with visual impairments.', 'alt-audit' ); ?></p>
							<div class="quality-indicators">
								<div class="indicator-item negative">
									<span class="dashicons dashicons-dismiss" aria-hidden="true"></span>
									<span><?php esc_html_e( 'Screen reader cannot describe image', 'alt-audit' ); ?></span>
								</div>
								<div class="indicator-item negative">
									<span class="dashicons dashicons-dismiss" aria-hidden="true"></span>
									<span><?php esc_html_e( 'WCAG compliance failure', 'alt-audit' ); ?></span>
								</div>
								<div class="indicator-item negative">
									<span class="dashicons dashicons-dismiss" aria-hidden="true"></span>
									<span><?php esc_html_e( 'SEO impact on image search', 'alt-audit' ); ?></span>
								</div>
							</div>
						</div>
					</div>

					<div class="quality-level quality-weak" style="--level-index: 2;">
						<div class="quality-badge">
							<div class="quality-score">41-60</div>
							<div class="quality-label"><?php esc_html_e( 'Weak', 'alt-audit' ); ?></div>
						</div>
						<div class="quality-content">
							<h3><?php esc_html_e( 'Weak Quality', 'alt-audit' ); ?></h3>
							<p><?php esc_html_e( 'Alt text present but lacks detail, too generic, contains accessibility issues, or uses problematic phrases like "image of" or "picture of".', 'alt-audit' ); ?></p>
							<div class="quality-indicators">
								<div class="indicator-item negative">
									<span class="dashicons dashicons-warning" aria-hidden="true"></span>
									<span><?php esc_html_e( 'Generic or vague descriptions', 'alt-audit' ); ?></span>
								</div>
								<div class="indicator-item negative">
									<span class="dashicons dashicons-warning" aria-hidden="true"></span>
									<span><?php esc_html_e( 'Missing important context', 'alt-audit' ); ?></span>
								</div>
								<div class="indicator-item positive">
									<span class="dashicons dashicons-yes-alt" aria-hidden="true"></span>
									<span><?php esc_html_e( 'Basic accessibility provided', 'alt-audit' ); ?></span>
								</div>
							</div>
						</div>
					</div>

					<div class="quality-level quality-good" style="--level-index: 3;">
						<div class="quality-badge">
							<div class="quality-score">61-85</div>
							<div class="quality-label"><?php esc_html_e( 'Good', 'alt-audit' ); ?></div>
						</div>
						<div class="quality-content">
							<h3><?php esc_html_e( 'Good Quality', 'alt-audit' ); ?></h3>
							<p><?php esc_html_e( 'Adequate description that meets basic accessibility standards. Provides clear context and avoids common mistakes.', 'alt-audit' ); ?></p>
							<div class="quality-indicators">
								<div class="indicator-item positive">
									<span class="dashicons dashicons-yes-alt" aria-hidden="true"></span>
									<span><?php esc_html_e( 'Clear and descriptive', 'alt-audit' ); ?></span>
								</div>
								<div class="indicator-item positive">
									<span class="dashicons dashicons-yes-alt" aria-hidden="true"></span>
									<span><?php esc_html_e( 'WCAG Level A compliance', 'alt-audit' ); ?></span>
								</div>
								<div class="indicator-item neutral">
									<span class="dashicons dashicons-info" aria-hidden="true"></span>
									<span><?php esc_html_e( 'Room for enhancement', 'alt-audit' ); ?></span>
								</div>
							</div>
						</div>
					</div>

					<div class="quality-level quality-excellent" style="--level-index: 4;">
						<div class="quality-badge">
							<div class="quality-score">86-100</div>
							<div class="quality-label"><?php esc_html_e( 'Excellent', 'alt-audit' ); ?></div>
						</div>
						<div class="quality-content">
							<h3><?php esc_html_e( 'Excellent Quality', 'alt-audit' ); ?></h3>
							<p><?php esc_html_e( 'Exceptional quality with rich, contextual description that enhances understanding and provides perfect accessibility compliance.', 'alt-audit' ); ?></p>
							<div class="quality-indicators">
								<div class="indicator-item positive">
									<span class="dashicons dashicons-yes-alt" aria-hidden="true"></span>
									<span><?php esc_html_e( 'Rich contextual information', 'alt-audit' ); ?></span>
								</div>
								<div class="indicator-item positive">
									<span class="dashicons dashicons-yes-alt" aria-hidden="true"></span>
									<span><?php esc_html_e( 'WCAG Level AA compliance', 'alt-audit' ); ?></span>
								</div>
								<div class="indicator-item positive">
									<span class="dashicons dashicons-yes-alt" aria-hidden="true"></span>
									<span><?php esc_html_e( 'Enhances user experience', 'alt-audit' ); ?></span>
								</div>
							</div>
						</div>
					</div>
				</div>

				<div class="quality-tips">
					<h3><?php esc_html_e( 'Quality Improvement Tips', 'alt-audit' ); ?></h3>
					<div class="tips-list">
						<div class="tip-item">
							<span class="tip-icon">
								<span class="dashicons dashicons-lightbulb" aria-hidden="true"></span>
							</span>
							<div class="tip-content">
								<strong><?php esc_html_e( 'Be Specific and Descriptive', 'alt-audit' ); ?></strong>
								<p><?php esc_html_e( 'Include relevant details about the image\'s content, context, and purpose rather than generic descriptions.', 'alt-audit' ); ?></p>
							</div>
						</div>
						<div class="tip-item">
							<span class="tip-icon">
								<span class="dashicons dashicons-format-quote" aria-hidden="true"></span>
							</span>
							<div class="tip-content">
								<strong><?php esc_html_e( 'Avoid Redundant Phrases', 'alt-audit' ); ?></strong>
								<p><?php esc_html_e( 'Don\'t use phrases like "image of", "picture of", or "photo of" - screen readers already announce it\'s an image.', 'alt-audit' ); ?></p>
							</div>
						</div>
						<div class="tip-item">
							<span class="tip-icon">
								<span class="dashicons dashicons-admin-page" aria-hidden="true"></span>
							</span>
							<div class="tip-content">
								<strong><?php esc_html_e( 'Consider Context', 'alt-audit' ); ?></strong>
								<p><?php esc_html_e( 'Tailor the description to match the image\'s purpose within the surrounding content and page context.', 'alt-audit' ); ?></p>
							</div>
						</div>
					</div>
				</div>
			</section>

			<!-- Troubleshooting -->
			<section id="troubleshooting" class="help-section" role="tabpanel" aria-labelledby="troubleshooting-tab">
				<div class="section-header">
					<h2 class="section-title">
						<span class="dashicons dashicons-sos" aria-hidden="true"></span>
						<?php esc_html_e( 'Troubleshooting Common Issues', 'alt-audit' ); ?>
					</h2>
					<p class="section-description"><?php esc_html_e( 'Quick solutions for common problems you might encounter while using Alt Audit.', 'alt-audit' ); ?></p>
				</div>

				<div class="troubleshooting-accordion">
					<div class="troubleshooting-item">
						<div class="trouble-header">
							<h3 class="trouble-title">
								<span class="dashicons dashicons-admin-network" aria-hidden="true"></span>
								<?php esc_html_e( 'API Connection Issues', 'alt-audit' ); ?>
							</h3>
							<button type="button" class="toggle-button" aria-expanded="false" aria-label="<?php esc_attr_e( 'Toggle API connection issues', 'alt-audit' ); ?>">
								<span class="dashicons dashicons-arrow-down-alt2" aria-hidden="true"></span>
							</button>
						</div>
						<div class="trouble-content">
							<p class="trouble-description"><?php esc_html_e( 'If you\'re experiencing problems connecting to the Alt Audit API service:', 'alt-audit' ); ?></p>
							<div class="solution-steps">
								<div class="step-item">
									<span class="step-icon">
										<span class="dashicons dashicons-admin-tools" aria-hidden="true"></span>
									</span>
									<div class="step-content">
										<strong><?php esc_html_e( 'Verify API Key', 'alt-audit' ); ?></strong>
										<p><?php esc_html_e( 'Double-check that your API key is correctly entered in the settings page without extra spaces or characters.', 'alt-audit' ); ?></p>
									</div>
								</div>
								<div class="step-item">
									<span class="step-icon">
										<span class="dashicons dashicons-admin-site" aria-hidden="true"></span>
									</span>
									<div class="step-content">
										<strong><?php esc_html_e( 'Check Network Connection', 'alt-audit' ); ?></strong>
										<p><?php esc_html_e( 'Ensure your server has stable internet connectivity and can make outbound HTTPS requests.', 'alt-audit' ); ?></p>
									</div>
								</div>
								<div class="step-item">
									<span class="step-icon">
										<span class="dashicons dashicons-shield" aria-hidden="true"></span>
									</span>
									<div class="step-content">
										<strong><?php esc_html_e( 'Review Firewall Settings', 'alt-audit' ); ?></strong>
										<p><?php esc_html_e( 'Contact your hosting provider to ensure firewall rules allow connections to api.altaudit.com on port 443.', 'alt-audit' ); ?></p>
									</div>
								</div>
							</div>
						</div>
					</div>

					<div class="troubleshooting-item">
						<div class="trouble-header">
							<h3 class="trouble-title">
								<span class="dashicons dashicons-update" aria-hidden="true"></span>
								<?php esc_html_e( 'Bulk Operations Not Working', 'alt-audit' ); ?>
							</h3>
							<button type="button" class="toggle-button" aria-expanded="false" aria-label="<?php esc_attr_e( 'Toggle bulk operations issues', 'alt-audit' ); ?>">
								<span class="dashicons dashicons-arrow-down-alt2" aria-hidden="true"></span>
							</button>
						</div>
						<div class="trouble-content">
							<p class="trouble-description"><?php esc_html_e( 'For issues with bulk operations timing out or failing:', 'alt-audit' ); ?></p>
							<div class="solution-steps">
								<div class="step-item">
									<span class="step-icon">
										<span class="dashicons dashicons-performance" aria-hidden="true"></span>
									</span>
									<div class="step-content">
										<strong><?php esc_html_e( 'Check Server Resources', 'alt-audit' ); ?></strong>
										<p><?php esc_html_e( 'Verify PHP memory limit (recommend 256MB+) and execution time limits (recommend 300+ seconds) in your hosting settings.', 'alt-audit' ); ?></p>
									</div>
								</div>
								<div class="step-item">
									<span class="step-icon">
										<span class="dashicons dashicons-admin-generic" aria-hidden="true"></span>
									</span>
									<div class="step-content">
										<strong><?php esc_html_e( 'Reduce Batch Size', 'alt-audit' ); ?></strong>
										<p><?php esc_html_e( 'Lower the number of images processed per batch in the plugin settings. Try starting with 10-25 images per batch.', 'alt-audit' ); ?></p>
									</div>
								</div>
								<div class="step-item">
									<span class="step-icon">
										<span class="dashicons dashicons-clock" aria-hidden="true"></span>
									</span>
									<div class="step-content">
										<strong><?php esc_html_e( 'Schedule During Off-Peak Hours', 'alt-audit' ); ?></strong>
										<p><?php esc_html_e( 'Run large bulk operations when your website has lower traffic to reduce server load and improve success rates.', 'alt-audit' ); ?></p>
									</div>
								</div>
							</div>
						</div>
					</div>

					<div class="troubleshooting-item">
						<div class="trouble-header">
							<h3 class="trouble-title">
								<span class="dashicons dashicons-admin-plugins" aria-hidden="true"></span>
								<?php esc_html_e( 'Plugin Conflicts', 'alt-audit' ); ?>
							</h3>
							<button type="button" class="toggle-button" aria-expanded="false" aria-label="<?php esc_attr_e( 'Toggle plugin conflict issues', 'alt-audit' ); ?>">
								<span class="dashicons dashicons-arrow-down-alt2" aria-hidden="true"></span>
							</button>
						</div>
						<div class="trouble-content">
							<p class="trouble-description"><?php esc_html_e( 'If experiencing conflicts with other plugins or themes:', 'alt-audit' ); ?></p>
							<div class="solution-steps">
								<div class="step-item">
									<span class="step-icon">
										<span class="dashicons dashicons-admin-plugins" aria-hidden="true"></span>
									</span>
									<div class="step-content">
										<strong><?php esc_html_e( 'Test Plugin Isolation', 'alt-audit' ); ?></strong>
										<p><?php esc_html_e( 'Temporarily deactivate other plugins one by one to identify conflicts. Test Alt Audit functionality after each deactivation.', 'alt-audit' ); ?></p>
									</div>
								</div>
								<div class="step-item">
									<span class="step-icon">
										<span class="dashicons dashicons-editor-code" aria-hidden="true"></span>
									</span>
									<div class="step-content">
										<strong><?php esc_html_e( 'Check Browser Console', 'alt-audit' ); ?></strong>
										<p><?php esc_html_e( 'Open your browser\'s developer tools and check for JavaScript errors that might indicate plugin conflicts.', 'alt-audit' ); ?></p>
									</div>
								</div>
								<div class="step-item">
									<span class="step-icon">
										<span class="dashicons dashicons-admin-appearance" aria-hidden="true"></span>
									</span>
									<div class="step-content">
										<strong><?php esc_html_e( 'Test Default Theme', 'alt-audit' ); ?></strong>
										<p><?php esc_html_e( 'Temporarily switch to a default WordPress theme to rule out theme-specific conflicts.', 'alt-audit' ); ?></p>
									</div>
								</div>
							</div>
						</div>
					</div>

					<div class="troubleshooting-item">
						<div class="trouble-header">
							<h3 class="trouble-title">
								<span class="dashicons dashicons-format-image" aria-hidden="true"></span>
								<?php esc_html_e( 'Images Not Being Detected', 'alt-audit' ); ?>
							</h3>
							<button type="button" class="toggle-button" aria-expanded="false" aria-label="<?php esc_attr_e( 'Toggle image detection issues', 'alt-audit' ); ?>">
								<span class="dashicons dashicons-arrow-down-alt2" aria-hidden="true"></span>
							</button>
						</div>
						<div class="trouble-content">
							<p class="trouble-description"><?php esc_html_e( 'If the audit is not finding images on your site:', 'alt-audit' ); ?></p>
							<div class="solution-steps">
								<div class="step-item">
									<span class="step-icon">
										<span class="dashicons dashicons-admin-media" aria-hidden="true"></span>
									</span>
									<div class="step-content">
										<strong><?php esc_html_e( 'Check Image Sources', 'alt-audit' ); ?></strong>
										<p><?php esc_html_e( 'Verify images are properly uploaded to the WordPress Media Library rather than external sources or hardcoded URLs.', 'alt-audit' ); ?></p>
									</div>
								</div>
								<div class="step-item">
									<span class="step-icon">
										<span class="dashicons dashicons-format-image" aria-hidden="true"></span>
									</span>
									<div class="step-content">
										<strong><?php esc_html_e( 'Check Image Format', 'alt-audit' ); ?></strong>
										<p><?php esc_html_e( 'Ensure images are in supported formats (JPEG, PNG, GIF, WebP) and have been properly processed by WordPress.', 'alt-audit' ); ?></p>
									</div>
								</div>
								<div class="step-item">
									<span class="step-icon">
										<span class="dashicons dashicons-update" aria-hidden="true"></span>
									</span>
									<div class="step-content">
										<strong><?php esc_html_e( 'Refresh Media Library', 'alt-audit' ); ?></strong>
										<p><?php esc_html_e( 'Try refreshing the audit page or clearing your browser cache if recently uploaded images are not appearing.', 'alt-audit' ); ?></p>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</section>

			<!-- Support -->
			<section id="support" class="help-section" role="tabpanel" aria-labelledby="support-tab">
				<div class="section-header">
					<h2 class="section-title">
						<span class="dashicons dashicons-groups" aria-hidden="true"></span>
						<?php esc_html_e( 'Get Support & Connect', 'alt-audit' ); ?>
					</h2>
					<p class="section-description"><?php esc_html_e( 'Multiple ways to get help, connect with the community, and access comprehensive resources.', 'alt-audit' ); ?></p>
				</div>

				<div class="support-options">
					<div class="support-card documentation-card">
						<div class="card-header">
							<div class="card-icon">
								<span class="dashicons dashicons-book-alt" aria-hidden="true"></span>
							</div>
							<h3><?php esc_html_e( 'Documentation Hub', 'alt-audit' ); ?></h3>
						</div>
						<div class="card-content">
							<p><?php esc_html_e( 'Comprehensive guides, tutorials, API documentation, and best practices for accessibility and alt text optimization.', 'alt-audit' ); ?></p>
							<div class="card-features">
								<div class="feature-item">
									<span class="dashicons dashicons-yes-alt" aria-hidden="true"></span>
									<span><?php esc_html_e( 'Step-by-step tutorials', 'alt-audit' ); ?></span>
								</div>
								<div class="feature-item">
									<span class="dashicons dashicons-yes-alt" aria-hidden="true"></span>
									<span><?php esc_html_e( 'Video walkthroughs', 'alt-audit' ); ?></span>
								</div>
								<div class="feature-item">
									<span class="dashicons dashicons-yes-alt" aria-hidden="true"></span>
									<span><?php esc_html_e( 'API reference guides', 'alt-audit' ); ?></span>
								</div>
							</div>
						</div>
						<div class="card-action">
							<?php
							$altaudit82ai_docs_url = add_query_arg(
								array(
									'utm_source'   => 'plugin',
									'utm_medium'   => 'help',
									'utm_campaign' => 'documentation',
								),
								'https://altaudit.com/docs'
							);
							?>
							<a href="<?php echo esc_url( $altaudit82ai_docs_url ); ?>" target="_blank" rel="noopener noreferrer" class="button button-secondary">
								<span class="dashicons dashicons-external" aria-hidden="true"></span>
								<?php esc_html_e( 'Browse Documentation', 'alt-audit' ); ?>
							</a>
						</div>
					</div>

					<div class="support-card contact-card">
						<div class="card-header">
							<div class="card-icon">
								<span class="dashicons dashicons-email-alt" aria-hidden="true"></span>
							</div>
							<h3><?php esc_html_e( 'Direct Support', 'alt-audit' ); ?></h3>
						</div>
						<div class="card-content">
							<p><?php esc_html_e( 'Get personalized help from our support team for technical issues, billing questions, and accessibility consultation.', 'alt-audit' ); ?></p>
							<div class="card-features">
								<div class="feature-item">
									<span class="dashicons dashicons-yes-alt" aria-hidden="true"></span>
									<span><?php esc_html_e( 'Expert technical support', 'alt-audit' ); ?></span>
								</div>
								<div class="feature-item">
									<span class="dashicons dashicons-yes-alt" aria-hidden="true"></span>
									<span><?php esc_html_e( '24-48 hour response time', 'alt-audit' ); ?></span>
								</div>
								<div class="feature-item">
									<span class="dashicons dashicons-yes-alt" aria-hidden="true"></span>
									<span><?php esc_html_e( 'Accessibility consultation', 'alt-audit' ); ?></span>
								</div>
							</div>
						</div>
						<div class="card-action">
							<?php
							$altaudit82ai_support_url = add_query_arg(
								array(
									'utm_source'   => 'plugin',
									'utm_medium'   => 'help',
									'utm_campaign' => 'support',
								),
								'https://altaudit.com/support'
							);
							?>
							<a href="<?php echo esc_url( $altaudit82ai_support_url ); ?>" target="_blank" rel="noopener noreferrer" class="button button-primary">
								<span class="dashicons dashicons-external" aria-hidden="true"></span>
								<?php esc_html_e( 'Contact Support', 'alt-audit' ); ?>
							</a>
						</div>
					</div>
				</div>

				<!-- System Information -->
				<div class="system-info-section">
					<h3 class="info-title"><?php esc_html_e( 'System Information', 'alt-audit' ); ?></h3>
					<p class="info-description"><?php esc_html_e( 'Include this information when contacting support to help us assist you more effectively:', 'alt-audit' ); ?></p>

					<div class="info-container">
						<div class="info-grid">
							<div class="info-item">
								<div class="info-label"><?php esc_html_e( 'Plugin Version', 'alt-audit' ); ?></div>
								<div class="info-value"><?php echo esc_html( ALTAUDIT82AI_VERSION ); ?></div>
							</div>
							<div class="info-item">
								<div class="info-label"><?php esc_html_e( 'WordPress Version', 'alt-audit' ); ?></div>
								<div class="info-value"><?php echo esc_html( get_bloginfo( 'version' ) ); ?></div>
							</div>
							<div class="info-item">
								<div class="info-label"><?php esc_html_e( 'PHP Version', 'alt-audit' ); ?></div>
								<div class="info-value"><?php echo esc_html( phpversion() ); ?></div>
							</div>
							<div class="info-item">
								<div class="info-label"><?php esc_html_e( 'Server Software', 'alt-audit' ); ?></div>
								<div class="info-value"><?php echo esc_html( isset( $_SERVER['SERVER_SOFTWARE'] ) ? sanitize_text_field( wp_unslash( $_SERVER['SERVER_SOFTWARE'] ) ) : __( 'Unknown', 'alt-audit' ) ); ?></div>
							</div>
							<div class="info-item">
								<div class="info-label"><?php esc_html_e( 'Memory Limit', 'alt-audit' ); ?></div>
								<div class="info-value"><?php echo esc_html( ini_get( 'memory_limit' ) ); ?></div>
							</div>
							<div class="info-item">
								<div class="info-label"><?php esc_html_e( 'Max Execution Time', 'alt-audit' ); ?></div>
								<div class="info-value"><?php echo esc_html( ini_get( 'max_execution_time' ) ); ?>s</div>
							</div>
						</div>

						<div class="copy-info-section">
							<button type="button" class="button button-secondary" id="copy-system-info">
								<span class="dashicons dashicons-clipboard" aria-hidden="true"></span>
								<?php esc_html_e( 'Copy System Info', 'alt-audit' ); ?>
							</button>
							<span class="copy-feedback" id="copy-feedback" style="display:none;"><?php esc_html_e( 'Copied to clipboard!', 'alt-audit' ); ?></span>
						</div>
					</div>
				</div>

			</section>
		</div>
	</div>
</div>

