<?php
/**
 * Admin Dashboard Template - Apple-Inspired Design
 *
 * @package AltAudit
 * @since 1.0.0
 */

// Prevent direct access.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// Security nonce for dashboard actions.
$altaudit82ai_dashboard_nonce = wp_create_nonce( 'altaudit82ai_dashboard_nonce' ); // phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound -- Template variable.

// Use the calculated quality score from stats.
$altaudit82ai_quality_score = $stats['avg_score'] ?? 0; // phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound -- Template variable.
$altaudit82ai_wcag_level    = $altaudit82ai_quality_score >= 80 ? 'AAA' : ( $altaudit82ai_quality_score >= 60 ? 'AA' : 'A' ); // phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound -- Template variable.
$altaudit82ai_last_scan     = '—'; // phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound -- Template variable.
?>

<div class="wrap alt-audit-section alt-audit-dashboard">
	<!-- Header Section -->
	<div class="alt-audit-header">
		<div class="header-content">
			<h1><?php echo esc_html( get_admin_page_title() ); ?></h1>
			<p class="alt-audit-subtitle">
				<?php esc_html_e( 'Monitor and improve your website\'s image accessibility with AI-powered insights', 'alt-audit' ); ?>
			</p>
		</div>
		<div class="header-actions">
			<a href="<?php echo esc_url( wp_nonce_url( admin_url( 'admin.php?page=alt-audit-audit' ), 'altaudit82ai_audit_nonce' ) ); ?>"
				class="alt-audit-btn-primary">
				<span class="btn-icon dashicons dashicons-search" aria-hidden="true"></span>
				<?php esc_html_e( 'Scan All Images', 'alt-audit' ); ?>
			</a>
		</div>
	</div>

	<!-- Status Overview Cards - Top Row -->
	<div class="status-overview-section">
		<div class="status-cards-grid">
			<div class="status-card card-missing">
				<div class="card-header">
					<div class="card-icon">
						<span class="dashicons dashicons-warning"></span>
					</div>
					<div class="card-status">
						<span class="status-indicator critical"></span>
						<span class="status-label"><?php esc_html_e( 'Critical', 'alt-audit' ); ?></span>
					</div>
				</div>
				<div class="card-content">
					<div class="card-number"><?php echo esc_html( number_format( $stats['missing_alt'] ) ); ?></div>
					<div class="card-title"><?php esc_html_e( 'Missing', 'alt-audit' ); ?></div>
					<div class="card-subtitle"><?php esc_html_e( 'No alt text', 'alt-audit' ); ?></div>
				</div>
			</div>


			<div class="status-card card-weak">
				<div class="card-header">
					<div class="card-icon">
						<span class="dashicons dashicons-info"></span>
					</div>
					<div class="card-status">
						<span class="status-indicator needs-fix"></span>
						<span class="status-label"><?php esc_html_e( 'Needs Fix', 'alt-audit' ); ?></span>
					</div>
				</div>
				<div class="card-content">
					<div class="card-number"><?php echo esc_html( number_format( $stats['weak_alt'] ) ); ?></div>
					<div class="card-title"><?php esc_html_e( 'Weak', 'alt-audit' ); ?></div>
					<div class="card-subtitle"><?php esc_html_e( 'Needs improvement', 'alt-audit' ); ?></div>
				</div>
			</div>

			<div class="status-card card-good">
				<div class="card-header">
					<div class="card-icon">
						<span class="dashicons dashicons-yes-alt"></span>
					</div>
					<div class="card-status">
						<span class="status-indicator acceptable"></span>
						<span class="status-label"><?php esc_html_e( 'Acceptable', 'alt-audit' ); ?></span>
					</div>
				</div>
				<div class="card-content">
					<div class="card-number"><?php echo esc_html( number_format( $stats['good_alt'] ) ); ?></div>
					<div class="card-title"><?php esc_html_e( 'Good', 'alt-audit' ); ?></div>
					<div class="card-subtitle"><?php esc_html_e( 'Meets standards', 'alt-audit' ); ?></div>
				</div>
			</div>

			<div class="status-card card-excellent">
				<div class="card-header">
					<div class="card-icon">
						<span class="dashicons dashicons-star-filled"></span>
					</div>
					<div class="card-status">
						<span class="status-indicator perfect"></span>
						<span class="status-label"><?php esc_html_e( 'Perfect', 'alt-audit' ); ?></span>
					</div>
				</div>
				<div class="card-content">
					<div class="card-number"><?php echo esc_html( number_format( $stats['excellent_alt'] ) ); ?></div>
					<div class="card-title"><?php esc_html_e( 'Excellent', 'alt-audit' ); ?></div>
					<div class="card-subtitle"><?php esc_html_e( 'Exceeds standards', 'alt-audit' ); ?></div>
				</div>
			</div>
		</div>
	</div>

	<!-- Middle Row - Quality Score & Quick Actions -->
	<div class="middle-section">
		<div class="quality-score-card">
			<div class="score-header">
				<h3 class="score-title"><?php esc_html_e( 'Overall Quality Score', 'alt-audit' ); ?></h3>
			</div>
			<div class="score-content">
				<div class="score-circle-container">
					<div class="score-circle" data-score="<?php echo esc_attr( $altaudit82ai_quality_score ); ?>" role="img"
						aria-label="<?php echo esc_attr( sprintf( /* translators: %d: Quality score percentage */ __( 'Quality score: %d percent', 'alt-audit' ), $altaudit82ai_quality_score ) ); ?>">
						<div class="score-inner">
							<div class="score-percentage"><?php echo esc_html( $altaudit82ai_quality_score ); ?>%</div>
							<div class="score-label"><?php esc_html_e( 'Quality', 'alt-audit' ); ?></div>
						</div>
					</div>
				</div>
				<div class="score-details">
					<div class="score-detail-item">
						<span class="detail-label"><?php esc_html_e( 'Last Scan:', 'alt-audit' ); ?></span>
						<span class="detail-value"><?php echo esc_html( $altaudit82ai_last_scan ); ?>
							<?php esc_html_e( 'ago', 'alt-audit' ); ?></span>
					</div>
					<div class="score-detail-item">
						<span class="detail-label"><?php esc_html_e( 'API Credits:', 'alt-audit' ); ?></span>
						<span class="detail-value">
							<span id="dashboard-credits">--</span>
							<?php
							$altaudit82ai_pricing_url = add_query_arg(
								array(
									'utm_source'   => 'plugin',
									'utm_medium'   => 'dashboard',
									'utm_campaign' => 'buy_credits',
								),
								'https://altaudit.com/pricing'
							);
							?>
							<a href="<?php echo esc_url( $altaudit82ai_pricing_url ); ?>" target="_blank" rel="noopener noreferrer" class="button button-small" style="margin-left:5px;min-height:20px;line-height:18px;padding:0 6px;font-size:11px;vertical-align:middle;"><?php esc_html_e( 'Buy', 'alt-audit' ); ?></a>
						</span>
					</div>
					<div class="score-detail-item">
						<span class="detail-label"><?php esc_html_e( 'Total Images:', 'alt-audit' ); ?></span>
						<span class="detail-value"><?php echo esc_html( number_format( $stats['total_images'] ) ); ?></span>
					</div>
				</div>
			</div>
		</div>

		<div class="quick-actions-card">
			<div class="actions-header">
				<h3 class="actions-title"><?php esc_html_e( 'Quick Actions', 'alt-audit' ); ?></h3>
			</div>
			<div class="actions-content">
				<div class="actions-grid">
					<a href="<?php echo esc_url( wp_nonce_url( admin_url( 'admin.php?page=alt-audit-audit' ), 'altaudit82ai_action_nonce' ) ); ?>"
						class="alt-audit-action-btn action-primary">
						<span class="action-icon dashicons dashicons-search"></span>
						<span class="action-label"><?php esc_html_e( 'Scan All Images', 'alt-audit' ); ?></span>
					</a>
					<a href="<?php echo esc_url( wp_nonce_url( admin_url( 'admin.php?page=alt-audit-bulk&action=generate' ), 'altaudit82ai_action_nonce' ) ); ?>"
						class="alt-audit-action-btn">
						<span class="action-icon dashicons dashicons-admin-generic"></span>
						<span class="action-label"><?php esc_html_e( 'Generate Missing', 'alt-audit' ); ?></span>
					</a>
					<a href="<?php echo esc_url( wp_nonce_url( admin_url( 'admin.php?page=alt-audit-bulk' ), 'altaudit82ai_action_nonce' ) ); ?>"
						class="alt-audit-action-btn">
						<span class="action-icon dashicons dashicons-admin-tools"></span>
						<span class="action-label"><?php esc_html_e( 'Bulk Process', 'alt-audit' ); ?></span>
					</a>
					<a href="<?php echo esc_url( wp_nonce_url( admin_url( 'admin.php?page=alt-audit-audit&action=export' ), 'altaudit82ai_action_nonce' ) ); ?>"
						class="alt-audit-action-btn">
						<span class="action-icon dashicons dashicons-download"></span>
						<span class="action-label"><?php esc_html_e( 'Export Report', 'alt-audit' ); ?></span>
					</a>
				</div>
			</div>
		</div>
	</div>

	<!-- Bottom Row - Priority Issues -->
	<div class="bottom-section">
		<div class="priority-issues-card">
			<div class="issues-header">
				<h3 class="issues-title"><?php esc_html_e( 'Priority Issues', 'alt-audit' ); ?></h3>
			</div>
			<div class="issues-content">
				<?php if ( $stats['missing_alt'] > 0 || $stats['weak_alt'] > 0 ) : ?>
					<div class="issues-list">
						<?php if ( $stats['missing_alt'] > 0 ) : ?>
							<div class="issue-item issue-critical">
								<div class="issue-icon">
									<span class="dashicons dashicons-warning"></span>
								</div>
								<div class="issue-details">
									<div class="issue-title"><?php echo esc_html( number_format( $stats['missing_alt'] ) ); ?>
										<?php esc_html_e( 'featured images missing alt text', 'alt-audit' ); ?>
									</div>
									<div class="issue-description">
										<?php esc_html_e( 'Critical accessibility violations', 'alt-audit' ); ?>
									</div>
								</div>
							</div>
						<?php endif; ?>

						<?php if ( $stats['weak_alt'] > 0 ) : ?>
							<div class="issue-item issue-warning">
								<div class="issue-icon">
									<span class="dashicons dashicons-info"></span>
								</div>
								<div class="issue-details">
									<div class="issue-title"><?php echo esc_html( number_format( $stats['weak_alt'] ) ); ?>
										<?php esc_html_e( 'images with weak descriptions', 'alt-audit' ); ?>
									</div>
									<div class="issue-description">
										<?php esc_html_e( 'Needs improvement for better accessibility', 'alt-audit' ); ?>
									</div>
								</div>
							</div>
						<?php endif; ?>

						<?php if ( isset( $stats['auto_generated'] ) && $stats['auto_generated'] > 0 ) : ?>
							<div class="issue-item issue-info">
								<div class="issue-icon">
									<span class="dashicons dashicons-admin-generic"></span>
								</div>
								<div class="issue-details">
									<div class="issue-title">
										<?php echo esc_html( number_format( $stats['auto_generated'] ) ); ?>
										<?php esc_html_e( 'auto-generated descriptions', 'alt-audit' ); ?>
									</div>
									<div class="issue-description">
										<?php esc_html_e( 'Review and refine AI suggestions', 'alt-audit' ); ?>
									</div>
								</div>
							</div>
						<?php endif; ?>
					</div>

					<div class="issues-action">
						<a href="<?php echo esc_url( wp_nonce_url( admin_url( 'admin.php?page=alt-audit-bulk&action=fix-priority' ), 'altaudit82ai_bulk_nonce' ) ); ?>"
							class="alt-audit-btn-secondary alt-audit-btn-full-width">
							<span class="btn-icon dashicons dashicons-admin-tools"></span>
							<?php esc_html_e( 'Fix All Priority Issues', 'alt-audit' ); ?>
						</a>
					</div>
				<?php else : ?>
					<div class="issues-empty">
						<div class="empty-icon success">
							<span class="dashicons dashicons-yes-alt"></span>
						</div>
						<div class="empty-text">
							<p><?php esc_html_e( 'No priority issues found', 'alt-audit' ); ?></p>
							<span><?php esc_html_e( 'Your images are well optimized for accessibility', 'alt-audit' ); ?></span>
						</div>
					</div>
				<?php endif; ?>
			</div>
		</div>
	</div>
</div>