<?php
/**
 * Admin Bulk Tools Template
 *
 * @package AltAudit
 * @since 1.0.0
 */

// Prevent direct access.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
?>

<div class="wrap alt-audit-section alt-audit-bulk">
	<div class="alt-audit-header">
		<h1><?php echo esc_html( get_admin_page_title() ); ?></h1>
		<p class="alt-audit-subtitle"><?php esc_html_e( 'Powerful batch operations for processing multiple images efficiently', 'alt-audit' ); ?></p>
	</div>

	<div class="alt-audit-bulk-container">
		<!-- Operations Grid -->
		<div class="bulk-operations-grid">
			<!-- Rule-Based Generation (FREE) -->
			<div class="bulk-operation-card generate-card free-card" style="--card-index: 0;">
				<div class="operation-header">
					<div class="operation-icon free-icon">
						<span class="dashicons dashicons-text" aria-hidden="true"></span>
					</div>
					<div class="operation-info">
						<h3>🆓 <?php esc_html_e( 'Rule-Based Alt Text Generation', 'alt-audit' ); ?></h3>
						<p><?php esc_html_e( 'Generate alt text for all images in your media library using your custom Alt Text Builder settings. No AI credits required - completely free!', 'alt-audit' ); ?></p>
					</div>
					<div class="operation-badge">
						<span class="operation-type free-badge"><?php esc_html_e( 'FREE', 'alt-audit' ); ?></span>
					</div>
				</div>

				<div class="operation-content">
					<div class="operation-options">
						<h4 class="options-title"><?php esc_html_e( 'Generation Options', 'alt-audit' ); ?></h4>

						<div class="option-group">
							<label class="modern-checkbox-label">
								<input type="checkbox" name="rule_skip_existing" id="rule_skip_existing">
								<span class="checkbox-custom"></span>
								<span class="checkbox-text">
									<strong><?php esc_html_e( 'Skip images with existing alt text', 'alt-audit' ); ?></strong>
									<span class="checkbox-description"><?php esc_html_e( 'Only process images that currently have no alt text', 'alt-audit' ); ?></span>
								</span>
							</label>
						</div>

						<div class="option-group">
							<label class="modern-checkbox-label">
								<input type="checkbox" name="rule_overwrite_weak" id="rule_overwrite_weak">
								<span class="checkbox-custom"></span>
								<span class="checkbox-text">
									<strong><?php esc_html_e( 'Improve weak quality alt text', 'alt-audit' ); ?></strong>
									<span class="checkbox-description"><?php esc_html_e( 'Replace alt text that scores below 60 quality points', 'alt-audit' ); ?></span>
								</span>
							</label>
						</div>
					</div>

					<div class="operation-actions">
						<button type="button" id="start-bulk-rule-generate" class="button button-primary button-hero alt-audit-operation-button">
							<span class="dashicons dashicons-text" aria-hidden="true"></span>
							<?php esc_html_e( 'Start Free Generation', 'alt-audit' ); ?>
						</button>
						<div class="operation-stats">
							<span class="stat-item">
								<span class="stat-number" id="rule-estimated-images">--</span>
								<span class="stat-label"><?php esc_html_e( 'Images Found', 'alt-audit' ); ?></span>
							</span>
							<span class="stat-item">
								<span class="stat-number free-label">🆓</span>
								<span class="stat-label"><?php esc_html_e( 'No Credits', 'alt-audit' ); ?></span>
							</span>
						</div>
					</div>
				</div>
			</div>

			<!-- AI-Powered Generation -->
			<div class="bulk-operation-card generate-card ai-card" style="--card-index: 1;">
				<div class="operation-header">
					<div class="operation-icon ai-icon">
						<span class="dashicons dashicons-admin-generic" aria-hidden="true"></span>
					</div>
					<div class="operation-info">
						<h3><?php esc_html_e( 'AI-Powered Alt Text Generation', 'alt-audit' ); ?></h3>
						<p><?php esc_html_e( 'Automatically generate high-quality, contextual alt text for all images in your media library using AI vision technology.', 'alt-audit' ); ?></p>
					</div>
					<div class="operation-badge">
						<span class="operation-type ai-badge"><?php esc_html_e( 'AI Enhancement', 'alt-audit' ); ?></span>
					</div>
				</div>

				<div class="operation-content">
					<div class="operation-options">
						<h4 class="options-title"><?php esc_html_e( 'Generation Options', 'alt-audit' ); ?></h4>

						<div class="option-group">
							<label class="modern-checkbox-label">
								<input type="checkbox" name="skip_existing" id="skip_existing">
								<span class="checkbox-custom"></span>
								<span class="checkbox-text">
									<strong><?php esc_html_e( 'Skip images with existing alt text', 'alt-audit' ); ?></strong>
									<span class="checkbox-description"><?php esc_html_e( 'Only process images that currently have no alt text', 'alt-audit' ); ?></span>
								</span>
							</label>
						</div>

						<div class="option-group">
							<label class="modern-checkbox-label">
								<input type="checkbox" name="overwrite_weak" id="overwrite_weak">
								<span class="checkbox-custom"></span>
								<span class="checkbox-text">
									<strong><?php esc_html_e( 'Improve weak quality alt text', 'alt-audit' ); ?></strong>
									<span class="checkbox-description"><?php esc_html_e( 'Replace alt text that scores below 60 quality points', 'alt-audit' ); ?></span>
								</span>
							</label>
						</div>
					</div>

					<div class="operation-actions">
						<button type="button" id="start-bulk-generate" class="button button-primary button-hero alt-audit-operation-button">
							<span class="dashicons dashicons-admin-generic" aria-hidden="true"></span>
							<?php esc_html_e( 'Start AI Generation', 'alt-audit' ); ?>
						</button>
						<div class="operation-stats">
							<span class="stat-item">
								<span class="stat-number" id="estimated-images">--</span>
								<span class="stat-label"><?php esc_html_e( 'Images Found', 'alt-audit' ); ?></span>
							</span>
							<span class="stat-item">
								<span class="stat-number" id="estimated-cost">--</span>
								<span class="stat-label"><?php esc_html_e( 'Credits Needed', 'alt-audit' ); ?></span>
							</span>
							<span class="stat-item">
								<span class="stat-number" id="available-credits">--</span>
								<span class="stat-label"><?php esc_html_e( 'Available', 'alt-audit' ); ?></span>
							</span>
						</div>
						<div class="credits-action">
							<?php
							$altaudit82ai_pricing_url = add_query_arg(
								array(
									'utm_source'   => 'plugin',
									'utm_medium'   => 'bulk_tools',
									'utm_campaign' => 'buy_credits',
								),
								'https://altaudit.com/pricing'
							);
							?>
							<a href="<?php echo esc_url( $altaudit82ai_pricing_url ); ?>" target="_blank" rel="noopener noreferrer" id="buy-credits-button" class="button button-secondary">
								<span class="dashicons dashicons-cart" aria-hidden="true"></span>
								<span class="button-text"><?php esc_html_e( 'Buy More Credits', 'alt-audit' ); ?></span>
							</a>
						</div>
					</div>
				</div>
			</div>



			<!-- Data Export Operation -->
			<div class="bulk-operation-card export-card" style="--card-index: 2;">
				<div class="operation-header">
					<div class="operation-icon export-icon">
						<span class="dashicons dashicons-download" aria-hidden="true"></span>
					</div>
					<div class="operation-info">
						<h3><?php esc_html_e( 'Data Export & Backup', 'alt-audit' ); ?></h3>
						<p><?php esc_html_e( 'Export comprehensive alt text data, quality scores, and audit results for backup or external analysis.', 'alt-audit' ); ?></p>
					</div>
					<div class="operation-badge">
						<span class="operation-type export-type"><?php esc_html_e( 'Data Export', 'alt-audit' ); ?></span>
					</div>
				</div>

				<div class="operation-content">
					<div class="format-selection">
						<h4 class="options-title"><?php esc_html_e( 'Export Format', 'alt-audit' ); ?></h4>
						<div class="format-options">
							<label class="format-option">
								<input type="radio" name="export_format" value="csv" checked="checked">
								<span class="format-card">
									<span class="format-icon">📊</span>
									<span class="format-name"><?php esc_html_e( 'CSV Format', 'alt-audit' ); ?></span>
									<span class="format-description"><?php esc_html_e( 'Spreadsheet-compatible', 'alt-audit' ); ?></span>
								</span>
							</label>
							<label class="format-option">
								<input type="radio" name="export_format" value="json">
								<span class="format-card">
									<span class="format-icon">⚡</span>
									<span class="format-name"><?php esc_html_e( 'JSON Format', 'alt-audit' ); ?></span>
									<span class="format-description"><?php esc_html_e( 'Developer-friendly', 'alt-audit' ); ?></span>
								</span>
							</label>
							<label class="format-option">
								<input type="radio" name="export_format" value="xml">
								<span class="format-card">
									<span class="format-icon">🏗️</span>
									<span class="format-name"><?php esc_html_e( 'XML Format', 'alt-audit' ); ?></span>
									<span class="format-description"><?php esc_html_e( 'Enterprise systems', 'alt-audit' ); ?></span>
								</span>
							</label>
						</div>
					</div>

					<div class="operation-actions">
						<button type="button" id="export-data" class="button button-secondary button-hero alt-audit-operation-button">
							<span class="dashicons dashicons-download" aria-hidden="true"></span>
							<?php esc_html_e( 'Export Data', 'alt-audit' ); ?>
						</button>
						<p class="operation-note"><?php esc_html_e( 'Includes all images, alt text, quality scores, and metadata.', 'alt-audit' ); ?></p>
					</div>
				</div>
			</div>
		</div>

		<!-- Progress Section -->
		<div class="bulk-progress-container" id="bulk-progress" style="display:none;">
			<div class="progress-card">
				<div class="progress-header">
					<h3 class="progress-title" id="progress-title">
						<span class="dashicons dashicons-update" aria-hidden="true"></span>
						<?php esc_html_e( 'Operation in Progress', 'alt-audit' ); ?>
					</h3>
					<button type="button" id="cancel-bulk" class="button button-secondary cancel-button">
						<span class="dashicons dashicons-dismiss" aria-hidden="true"></span>
						<?php esc_html_e( 'Cancel Operation', 'alt-audit' ); ?>
					</button>
				</div>

				<div class="progress-content">
					<div class="progress-bar-container">
						<div class="progress-bar modern-progress">
							<div class="progress-fill" id="bulk-progress-fill" style="width: 0%;"></div>
						</div>
						<div class="progress-percentage" id="bulk-progress-percentage">0%</div>
					</div>

					<p class="progress-text" id="bulk-progress-text"><?php esc_html_e( 'Preparing operation...', 'alt-audit' ); ?></p>

					<div class="progress-stats" id="bulk-progress-stats">
						<div class="stat-item" id="processed-stat">
							<div class="stat-number" id="processed-count">0</div>
							<div class="stat-label"><?php esc_html_e( 'Processed', 'alt-audit' ); ?></div>
						</div>
						<div class="stat-item" id="total-stat">
							<div class="stat-number" id="total-count">0</div>
							<div class="stat-label"><?php esc_html_e( 'Total', 'alt-audit' ); ?></div>
						</div>
						<div class="stat-item" id="success-stat">
							<div class="stat-number" id="success-count">0</div>
							<div class="stat-label"><?php esc_html_e( 'Success', 'alt-audit' ); ?></div>
						</div>
						<div class="stat-item" id="error-stat">
							<div class="stat-number" id="error-count">0</div>
							<div class="stat-label"><?php esc_html_e( 'Errors', 'alt-audit' ); ?></div>
						</div>
					</div>

					<div class="progress-log" id="progress-log" style="display:none;">
						<h4><?php esc_html_e( 'Operation Log', 'alt-audit' ); ?></h4>
						<div class="log-container">
							<div class="log-content" id="log-content"></div>
						</div>
						<button type="button" class="button button-small toggle-log" id="hide-log-btn">
							<?php esc_html_e( 'Hide Log', 'alt-audit' ); ?>
						</button>
					</div>

					<button type="button" class="button button-small toggle-log" id="show-log-btn">
						<?php esc_html_e( 'Show Detailed Log', 'alt-audit' ); ?>
					</button>
				</div>
			</div>
		</div>

		<!-- Results Section -->
		<div class="bulk-results-container" id="bulk-results" style="display:none;">
			<div class="results-card">
				<div class="results-header">
					<h3 class="results-title">
						<span class="dashicons dashicons-yes-alt" aria-hidden="true"></span>
						<?php esc_html_e( 'Operation Completed Successfully', 'alt-audit' ); ?>
					</h3>
					<div class="results-actions">
						<button type="button" class="button button-primary" id="download-report">
							<span class="dashicons dashicons-download" aria-hidden="true"></span>
							<?php esc_html_e( 'Download Report', 'alt-audit' ); ?>
						</button>
						<button type="button" class="button button-secondary" id="start-new-operation">
							<span class="dashicons dashicons-controls-repeat" aria-hidden="true"></span>
							<?php esc_html_e( 'Start New Operation', 'alt-audit' ); ?>
						</button>
					</div>
				</div>

				<div class="results-content">
					<div class="results-summary" id="results-summary">
						<!-- Results will be populated by JavaScript -->
					</div>

					<div class="results-details">
						<div class="detail-tabs">
							<button type="button" class="detail-tab active" data-tab="summary"><?php esc_html_e( 'Summary', 'alt-audit' ); ?></button>
							<button type="button" class="detail-tab" data-tab="log"><?php esc_html_e( 'Detailed Log', 'alt-audit' ); ?></button>
							<button type="button" class="detail-tab" data-tab="errors"><?php esc_html_e( 'Errors', 'alt-audit' ); ?></button>
						</div>

						<div class="detail-content">
							<div class="detail-panel active" id="summary-panel">
								<!-- Summary content -->
							</div>
							<div class="detail-panel" id="log-panel">
								<div class="log-viewer">
									<textarea readonly="readonly" class="results-log-textarea" id="results-log-content"></textarea>
								</div>
							</div>
							<div class="detail-panel" id="errors-panel">
								<div class="error-list" id="error-list">
									<!-- Error content -->
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>
