<?php
/**
 * Admin Accessibility Audit Template
 *
 * @package AltAudit
 * @since 1.0.0
 *
 * @var Altaudit82ai_Images_List_Table $images_list_table The images list table instance.
 */

// Prevent direct access.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// Display admin notices.
settings_errors( 'altaudit82ai_notices' );
?>

<div class="wrap alt-audit-section alt-audit-audit" data-page="audit">
	<!-- Notification Container -->
	<div class="alt-audit-notifications"></div>

	<!-- Header Section -->
	<div class="alt-audit-header">
		<div class="header-content">
			<h1><?php echo esc_html( get_admin_page_title() ); ?></h1>
			<p class="alt-audit-subtitle"><?php esc_html_e( 'Review and manage alt text for all your website images', 'alt-audit' ); ?></p>
		</div>
		<div class="header-actions">
			<a href="<?php echo esc_url( wp_nonce_url( admin_url( 'admin.php?page=alt-audit-bulk' ), 'altaudit82ai_bulk_nonce' ) ); ?>" class="alt-audit-btn-secondary">
				<span class="btn-icon dashicons dashicons-admin-tools" aria-hidden="true"></span>
				<?php esc_html_e( 'Bulk Tools', 'alt-audit' ); ?>
			</a>
		</div>
	</div>

	<?php if ( isset( $this->images_list_table ) ) : ?>
		<?php
		// Get overall statistics.
		$stats = $this->images_list_table->get_statistics(); // phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound -- Template variable.
		?>

		<!-- Overall Statistics Section -->
		<div class="alt-audit-statistics-section">
			<div class="alt-audit-stats-container">
				<!-- Overall Score Card -->
				<div class="alt-audit-stat-card alt-audit-overall-score">
					<div class="stat-ring-container">
						<svg class="stat-ring" viewBox="0 0 120 120" width="120" height="120">
							<!-- Background ring -->
							<circle class="ring-background" cx="60" cy="60" r="52" fill="none" stroke-width="8"></circle>
							<!-- Progress ring -->
							<circle
								class="ring-progress"
								cx="60"
								cy="60"
								r="52"
								fill="none"
								stroke-width="8"
								stroke-linecap="round"
								style="--score: <?php echo esc_attr( $stats['avg_score'] ); ?>;"
							></circle>
						</svg>
						<div class="stat-ring-value">
							<span class="ring-score"><?php echo esc_html( $stats['avg_score'] ); ?></span>
							<span class="ring-unit">/100</span>
						</div>
					</div>
					<div class="stat-content">
						<div class="stat-label"><?php esc_html_e( 'Overall Quality Score', 'alt-audit' ); ?></div>
						<div class="stat-description">
							<?php
							if ( $stats['avg_score'] >= 80 ) {
								esc_html_e( 'Excellent accessibility', 'alt-audit' );
							} elseif ( $stats['avg_score'] >= 60 ) {
								esc_html_e( 'Good accessibility', 'alt-audit' );
							} elseif ( $stats['avg_score'] >= 40 ) {
								esc_html_e( 'Needs improvement', 'alt-audit' );
							} else {
								esc_html_e( 'Action required', 'alt-audit' );
							}
							?>
						</div>
					</div>
				</div>

				<!-- Total Images Card -->
				<div class="alt-audit-stat-card">
					<div class="stat-icon">
						<span class="dashicons dashicons-images-alt2"></span>
					</div>
					<div class="stat-content">
						<div class="stat-label"><?php esc_html_e( 'Total Images', 'alt-audit' ); ?></div>
						<div class="stat-value"><?php echo esc_html( number_format_i18n( $stats['total'] ) ); ?></div>
					</div>
				</div>

				<!-- Status Breakdown -->
				<div class="alt-audit-stat-card alt-audit-status-breakdown">
					<div class="stat-icon">
						<span class="dashicons dashicons-analytics"></span>
					</div>
					<div class="stat-content">
						<div class="stat-label"><?php esc_html_e( 'Status Breakdown', 'alt-audit' ); ?></div>
						<div class="status-grid">
							<div class="status-item status-missing">
								<span class="status-count"><?php echo esc_html( $stats['missing'] ); ?></span>
								<span class="status-label"><?php esc_html_e( 'Missing', 'alt-audit' ); ?></span>
							</div>
							<div class="status-item status-weak">
								<span class="status-count"><?php echo esc_html( $stats['weak'] ); ?></span>
								<span class="status-label"><?php esc_html_e( 'Weak', 'alt-audit' ); ?></span>
							</div>
							<div class="status-item status-good">
								<span class="status-count"><?php echo esc_html( $stats['good'] ); ?></span>
								<span class="status-label"><?php esc_html_e( 'Good', 'alt-audit' ); ?></span>
							</div>
							<div class="status-item status-excellent">
								<span class="status-count"><?php echo esc_html( $stats['excellent'] ); ?></span>
								<span class="status-label"><?php esc_html_e( 'Excellent', 'alt-audit' ); ?></span>
							</div>
							<?php
							/*
							Decorative status removed - simplified status system
							<div class="status-item status-decorative">
								<span class="status-count"><?php echo esc_html( $stats['decorative'] ); ?></span>
								<span class="status-label"><?php esc_html_e( 'Decorative', 'alt-audit' ); ?></span>
							</div>
							*/
							?>
						</div>
					</div>
				</div>
			</div>
		</div>

		<!-- Search & Filter Section -->
		<div class="audit-table-section" data-ajax-container="table">
			<!-- Scan Prompt (shown initially) -->
			<div class="alt-audit-scan-prompt" style="text-align: center; padding: 60px 20px; background: #fff; border: 1px solid #c3c4c7; border-radius: 4px;">
				<span class="dashicons dashicons-search" style="font-size: 48px; width: 48px; height: 48px; color: #2271b1; margin-bottom: 20px;"></span>
				<h2 style="margin: 0 0 10px; font-size: 1.5em;"><?php esc_html_e( 'Scan Your Images', 'alt-audit' ); ?></h2>
				<p style="color: #646970; margin: 0 0 20px; max-width: 500px; margin-left: auto; margin-right: auto;">
					<?php esc_html_e( 'Click the button below to analyze all your images and generate quality scores for their alt text.', 'alt-audit' ); ?>
				</p>
				<button type="button" id="altaudit82ai-scan-all-btn" class="button button-primary button-hero" data-nonce="<?php echo esc_attr( wp_create_nonce( 'altaudit82ai_scan_all' ) ); ?>">
					<span class="dashicons dashicons-search" style="margin-top: 5px;"></span>
					<?php esc_html_e( 'Scan All Images', 'alt-audit' ); ?>
				</button>
			</div>

			<!-- Progress Indicator (Hidden by default) -->
			<div class="alt-audit-progress-container" style="display:none;">
				<div class="alt-audit-progress-bar">
					<div class="alt-audit-progress-fill"></div>
				</div>
				<div class="alt-audit-progress-text">
					<span class="progress-message"><?php esc_html_e( 'Processing...', 'alt-audit' ); ?></span>
					<button type="button" class="button alt-audit-cancel-operation"><?php esc_html_e( 'Cancel', 'alt-audit' ); ?></button>
				</div>
			</div>

			<!-- Table Form (Hidden initially, shown after scan) -->
			<form method="get" class="alt-audit-images-form" role="search" aria-label="<?php esc_attr_e( 'Image search and filters', 'alt-audit' ); ?>" data-ajax-form="audit" style="display: none;">
				<?php wp_nonce_field( 'altaudit82ai_list_table', '_altaudit82ai_nonce', false ); ?>
				<input type="hidden" name="page" value="<?php echo esc_attr( 'alt-audit-audit' ); ?>" />

				<?php
				// Search box.
				$this->images_list_table->search_box( __( 'Search images', 'alt-audit' ), 'altaudit82ai-images' );
				?>

				<?php
				// Display the table.
				$this->images_list_table->display();
				?>
			</form>
		</div>

		<!-- Inline Edit Form Template (Hidden) -->
		<div id="alt-audit-inline-edit" class="alt-audit-inline-edit-template" style="display: none;" aria-hidden="true">
			<div class="inline-edit-wrapper">
				<fieldset>
					<legend class="inline-edit-legend"><?php esc_html_e( 'Edit Alt Text', 'alt-audit' ); ?></legend>

					<label for="inline-edit-alt-text">
						<span class="label"><?php esc_html_e( 'Alt Text:', 'alt-audit' ); ?></span>
						<textarea id="inline-edit-alt-text" class="inline-edit-textarea" rows="3" cols="50" aria-label="<?php esc_attr_e( 'Alt text editor', 'alt-audit' ); ?>"></textarea>
					</label>

					<div class="inline-edit-actions">
						<button type="button" class="button button-primary" id="save-inline-edit" aria-label="<?php esc_attr_e( 'Save changes', 'alt-audit' ); ?>">
							<?php esc_html_e( 'Update', 'alt-audit' ); ?>
						</button>
						<button type="button" class="button" id="cancel-inline-edit" aria-label="<?php esc_attr_e( 'Cancel editing', 'alt-audit' ); ?>">
							<?php esc_html_e( 'Cancel', 'alt-audit' ); ?>
						</button>
						<span class="spinner" role="status" aria-label="<?php esc_attr_e( 'Saving...', 'alt-audit' ); ?>"></span>
					</div>
				</fieldset>
			</div>
		</div>

		<!-- Bulk Actions Form -->
		<form method="post" id="alt-audit-bulk-form" aria-label="<?php esc_attr_e( 'Bulk actions form', 'alt-audit' ); ?>">
			<?php wp_nonce_field( 'altaudit82ai_bulk_action' ); ?>
		</form>

	<?php else : ?>
		<div class="notice notice-error">
			<p><?php esc_html_e( 'Images list table could not be loaded.', 'alt-audit' ); ?></p>
		</div>
	<?php endif; ?>
</div>
