<?php
/**
 * Plugin Name: Alt Audit - AI Alt Text Generator & Accessibility Checker
 * Plugin URI: https://altaudit.com
 * Description: Generate image alt text with AI or rule-based templates. Audit accessibility with WCAG compliance, bulk processing, and quality scoring.
 * Version: 1.0.5
 * Author: Flance
 * Author URI: https://flance.info
 * License: GPL v2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain: alt-audit
 * Domain Path: /languages
 * Requires at least: 6.2
 * Tested up to: 6.9
 * Requires PHP: 7.4
 *
 * @package AltAudit
 * @version 1.0.5
 * @since 1.0.0
 */

// Prevent direct access.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// Define plugin constants.
define( 'ALTAUDIT82AI_VERSION', '1.0.5' );
define( 'ALTAUDIT82AI_PLUGIN_FILE', __FILE__ );
define( 'ALTAUDIT82AI_PLUGIN_DIR', plugin_dir_path( __FILE__ ) );
define( 'ALTAUDIT82AI_PLUGIN_URL', plugin_dir_url( __FILE__ ) );
define( 'ALTAUDIT82AI_PLUGIN_BASENAME', plugin_basename( __FILE__ ) );
define( 'ALTAUDIT82AI_TEXT_DOMAIN', 'alt-audit' );

// Define API constants.
define( 'ALTAUDIT82AI_API_BASE_URL', 'https://altaudit.com/api/v1' );
define( 'ALTAUDIT82AI_API_TIMEOUT', 40 );

// Define path constants.
define( 'ALTAUDIT82AI_INCLUDES_DIR', ALTAUDIT82AI_PLUGIN_DIR . 'includes/' );
define( 'ALTAUDIT82AI_ASSETS_DIR', ALTAUDIT82AI_PLUGIN_DIR . 'assets/' );
define( 'ALTAUDIT82AI_VIEWS_DIR', ALTAUDIT82AI_PLUGIN_DIR . 'includes/Views/' );
define( 'ALTAUDIT82AI_CONTROLLERS_DIR', ALTAUDIT82AI_PLUGIN_DIR . 'includes/Controllers/' );
define( 'ALTAUDIT82AI_TEMPLATES_DIR', ALTAUDIT82AI_PLUGIN_DIR . 'templates/' );
define( 'ALTAUDIT82AI_TESTS_DIR', ALTAUDIT82AI_PLUGIN_DIR . 'tests/' );

// Define URL constants.
define( 'ALTAUDIT82AI_ASSETS_URL', ALTAUDIT82AI_PLUGIN_URL . 'assets/' );
define( 'ALTAUDIT82AI_IMAGES_URL', ALTAUDIT82AI_ASSETS_URL . 'images/' );

// Load the main plugin class.
require_once ALTAUDIT82AI_INCLUDES_DIR . 'class-altaudit82ai.php';

/**
 * Get the main plugin instance
 *
 * @return Altaudit82ai
 */
function altaudit82ai() {
	return Altaudit82ai::instance();
}

// Initialize the plugin.
altaudit82ai();
