<?php
/**
 * Plugin Name: All in one checkout page builder for woocommerce
 * Plugin URI:  https://trustyplugins.com
 * Description: A base plugin to override the WooCommerce checkout layout and prepare for a custom drag-and-drop builder.
 * Version: 1.0.0
 * Author:      Trusty Plugins
 * License:     GPL2
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain: all-in-one-checkout-page-builder-for-woocommerce
 * Domain Path: /languages
 * Requires Plugins: woocommerce
 */

if ( ! defined( 'ABSPATH' ) ) exit;

define('TRUSTY_WOO_CHECKOUT_VERSION', '1.0.0');

if (!defined('TRUSTY_WOO_CHECKOUT_PATH')) {
    define('TRUSTY_WOO_CHECKOUT_PATH', plugin_dir_path(__FILE__));
}
if (!defined('TRUSTY_WOO_CHECKOUT_URL')) {
    define('TRUSTY_WOO_CHECKOUT_URL', plugin_dir_url(__FILE__));
}
add_action( 'admin_notices', function() {
    if ( is_admin() && get_option( 'woocommerce_checkout_page_id' ) ) {
        $checkout_page_id = get_option( 'woocommerce_checkout_page_id' );
        $content = get_post_field( 'post_content', $checkout_page_id );

        if ( strpos( $content, '[woocommerce_checkout]' ) === false ) {
            echo '<div class="notice notice-error"><p>';
            echo 'Your checkout page does not contain the required <code>[woocommerce_checkout]</code> shortcode. The Checkout Builder plugin may not work as expected.';
            echo '</p></div>';
        }
    }
});


add_filter( 'woocommerce_locate_template', 'trusty_woo_override_woocommerce_templates', 10, 3 );

function trusty_woo_override_woocommerce_templates( $template, $template_name, $template_path ) {
    $plugin_path = plugin_dir_path( __FILE__ ) . 'templates/woocommerce/';

    if ( file_exists( $plugin_path . $template_name ) ) {
        return $plugin_path . $template_name;
    }

    return $template;
}
// Load the admin bar button toggle functionality
require_once plugin_dir_path(__FILE__) . 'includes/functions.php';

