<?php

/**
 * Checkout shipping information form
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/checkout/form-shipping.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 3.6.0
 * @global WC_Checkout $checkout
 */

defined('ABSPATH') || exit;
?>
<div class="woocommerce-shipping-fields">
	<?php if (true === WC()->cart->needs_shipping_address()) : ?>
		<?php
		if (get_option('trusty_active_template')) {
			$active_layout = get_option('trusty_active_template');
			$layout_data = json_decode(get_post_meta($active_layout, 'trusty_checkout_data', true));

			if (!empty($layout_data) && isset($layout_data->post_layout_data->initial_data)) {
				$layout = $layout_data->post_layout_data->initial_data;
			} else {
				$layout = []; // fallback to empty array or handle error
			}
			$shipping_display = '';
			$shipping_checked = '';
			$shipping_label = 'Ship to a different address?';
			foreach ($layout as $rowkey => $row) {
				foreach ($row->data as $columnkey => $column) {
					foreach ($column->data as $modulekey => $module) {
						if ($module->key == 'shipping_fields') {
							$shipping_display = $module->settings->display_shipping;
							$shipping_checked = $module->settings->shipping_checked;
							$shipping_label = $module->settings->shipping_diff_label;
						}
					}
				}
			}
		}


		if ($shipping_display == 1) {
		?>
			<h3 id="ship-to-different-address">
				<label class="woocommerce-form__label woocommerce-form__label-for-checkbox checkbox">
					<input
						id="ship-to-different-address-checkbox"
						class="woocommerce-form__input woocommerce-form__input-checkbox input-checkbox"
						type="checkbox"
						name="ship_to_different_address"
						value="1"
						<?php checked($shipping_checked); ?> />
					<span><?php echo esc_html($shipping_label); ?></span>

				</label>
			</h3>
		<?php } ?>

		<div class="shipping_address">

			<?php do_action('woocommerce_before_checkout_shipping_form', $checkout); ?>

			<div class="woocommerce-shipping-fields__field-wrapper">
				<?php
				$fields = $checkout->get_checkout_fields('shipping');

				foreach ($fields as $key => $field) {
					woocommerce_form_field($key, $field, $checkout->get_value($key));
				}
				?>
			</div>

			<?php do_action('woocommerce_after_checkout_shipping_form', $checkout); ?>

		</div>

	<?php endif; ?>
</div>
<div class="woocommerce-additional-fields">
	<?php do_action('woocommerce_before_order_notes', $checkout); ?>
	<?php do_action('woocommerce_after_order_notes', $checkout); ?>
</div>